/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.biome;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.impl.biome.TheEndBiomeData;
import net.fabricmc.fabric.mixin.biome.BiomeSourceMixin;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.RegistryOps;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.source.TheEndBiomeSource;
import net.minecraft.world.biome.source.util.MultiNoiseUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TheEndBiomeSource.class})
public class TheEndBiomeSourceMixin
extends BiomeSourceMixin {
    @Shadow
    @Mutable
    @Final
    static Codec<TheEndBiomeSource> field_24730;
    @Unique
    private Supplier<TheEndBiomeData.Overrides> overrides;
    @Unique
    private boolean biomeSetModified = false;
    @Unique
    private boolean hasCheckedForModifiedSet = false;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void modifyCodec(CallbackInfo ci) {
        field_24730 = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.getEntryLookupCodec((RegistryKey)RegistryKeys.BIOME)).apply((Applicative)instance, instance.stable(TheEndBiomeSource::createVanilla)));
    }

    @Inject(method={"createVanilla"}, at={@At(value="HEAD")})
    private static void rememberLookup(RegistryEntryLookup<Biome> biomes, CallbackInfoReturnable<?> ci) {
        TheEndBiomeData.biomeRegistry.set(biomes);
    }

    @Inject(method={"createVanilla"}, at={@At(value="TAIL")})
    private static void clearLookup(RegistryEntryLookup<Biome> biomes, CallbackInfoReturnable<?> ci) {
        TheEndBiomeData.biomeRegistry.remove();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(RegistryEntry<Biome> centerBiome, RegistryEntry<Biome> highlandsBiome, RegistryEntry<Biome> midlandsBiome, RegistryEntry<Biome> smallIslandsBiome, RegistryEntry<Biome> barrensBiome, CallbackInfo ci) {
        RegistryEntryLookup<Biome> biomes = TheEndBiomeData.biomeRegistry.get();
        if (biomes == null) {
            throw new IllegalStateException("Biome registry not set by Mixin");
        }
        this.overrides = Suppliers.memoize(() -> TheEndBiomeData.createOverrides(biomes));
    }

    @Inject(method={"getBiome"}, at={@At(value="RETURN")}, cancellable=true)
    private void getWeightedEndBiome(int biomeX, int biomeY, int biomeZ, MultiNoiseUtil.MultiNoiseSampler noise, CallbackInfoReturnable<RegistryEntry<Biome>> cir) {
        cir.setReturnValue(this.overrides.get().pick(biomeX, biomeY, biomeZ, noise, (RegistryEntry<Biome>)((RegistryEntry)cir.getReturnValue())));
    }

    @Override
    protected Set<RegistryEntry<Biome>> fabric_modifyBiomeSet(Set<RegistryEntry<Biome>> biomes) {
        if (!this.hasCheckedForModifiedSet) {
            this.hasCheckedForModifiedSet = true;
            boolean bl = this.biomeSetModified = !this.overrides.get().customBiomes.isEmpty();
        }
        if (this.biomeSetModified) {
            LinkedHashSet<RegistryEntry<Biome>> modifiedBiomes = new LinkedHashSet<RegistryEntry<Biome>>(biomes);
            modifiedBiomes.addAll(this.overrides.get().customBiomes);
            return Collections.unmodifiableSet(modifiedBiomes);
        }
        return biomes;
    }
}

