/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.biome;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.impl.biome.MultiNoiseSamplerHooks;
import net.minecraft.util.math.noise.PerlinNoiseSampler;
import net.minecraft.util.math.random.CheckedRandom;
import net.minecraft.util.math.random.ChunkRandom;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.biome.source.util.MultiNoiseUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MultiNoiseUtil.MultiNoiseSampler.class})
public class MultiNoiseUtilMultiNoiseSamplerMixin
implements MultiNoiseSamplerHooks {
    @Unique
    private Long seed = null;
    @Unique
    private PerlinNoiseSampler endBiomesSampler = null;

    @Override
    public void fabric_setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public long fabric_getSeed() {
        return this.seed;
    }

    @Override
    public PerlinNoiseSampler fabric_getEndBiomesSampler() {
        if (this.endBiomesSampler == null) {
            Preconditions.checkState((this.seed != null ? 1 : 0) != 0, (Object)"MultiNoiseSampler doesn't have a seed set, created using different method?");
            this.endBiomesSampler = new PerlinNoiseSampler((Random)new ChunkRandom((Random)new CheckedRandom(this.seed.longValue())));
        }
        return this.endBiomesSampler;
    }
}

