/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome.modification;

import java.util.Optional;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionOptions;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.PlacedFeature;
import net.minecraft.world.gen.structure.Structure;

public class BiomeSelectionContextImpl
implements BiomeSelectionContext {
    private final DynamicRegistryManager dynamicRegistries;
    private final RegistryKey<Biome> key;
    private final Biome biome;
    private final RegistryEntry<Biome> entry;

    public BiomeSelectionContextImpl(DynamicRegistryManager dynamicRegistries, RegistryKey<Biome> key, Biome biome) {
        this.dynamicRegistries = dynamicRegistries;
        this.key = key;
        this.biome = biome;
        this.entry = (RegistryEntry)dynamicRegistries.get(RegistryKeys.BIOME).getEntry(this.key).orElseThrow();
    }

    @Override
    public RegistryKey<Biome> getBiomeKey() {
        return this.key;
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public RegistryEntry<Biome> getBiomeRegistryEntry() {
        return this.entry;
    }

    @Override
    public Optional<RegistryKey<ConfiguredFeature<?, ?>>> getFeatureKey(ConfiguredFeature<?, ?> configuredFeature) {
        Registry registry = this.dynamicRegistries.get(RegistryKeys.CONFIGURED_FEATURE);
        return registry.getKey(configuredFeature);
    }

    @Override
    public Optional<RegistryKey<PlacedFeature>> getPlacedFeatureKey(PlacedFeature placedFeature) {
        Registry registry = this.dynamicRegistries.get(RegistryKeys.PLACED_FEATURE);
        return registry.getKey((Object)placedFeature);
    }

    @Override
    public boolean validForStructure(RegistryKey<Structure> key) {
        Structure instance = (Structure)this.dynamicRegistries.get(RegistryKeys.STRUCTURE).get(key);
        if (instance == null) {
            return false;
        }
        return instance.getValidBiomes().contains(this.getBiomeRegistryEntry());
    }

    @Override
    public Optional<RegistryKey<Structure>> getStructureKey(Structure structure) {
        Registry registry = this.dynamicRegistries.get(RegistryKeys.STRUCTURE);
        return registry.getKey((Object)structure);
    }

    @Override
    public boolean canGenerateIn(RegistryKey<DimensionOptions> dimensionKey) {
        DimensionOptions dimension = (DimensionOptions)this.dynamicRegistries.get(RegistryKeys.DIMENSION).get(dimensionKey);
        if (dimension == null) {
            return false;
        }
        return dimension.chunkGenerator().getBiomeSource().getBiomes().stream().anyMatch(entry -> entry.value() == this.biome);
    }

    @Override
    public boolean hasTag(TagKey<Biome> tag) {
        Registry biomeRegistry = this.dynamicRegistries.get(RegistryKeys.BIOME);
        return biomeRegistry.entryOf(this.getBiomeKey()).isIn(tag);
    }
}

