/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnGroup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.sound.BiomeAdditionsSound;
import net.minecraft.sound.BiomeMoodSound;
import net.minecraft.sound.MusicSound;
import net.minecraft.sound.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEffects;
import net.minecraft.world.biome.BiomeParticleConfig;
import net.minecraft.world.biome.SpawnSettings;
import net.minecraft.world.gen.GenerationStep;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.PlacedFeature;
import org.jetbrains.annotations.NotNull;

public interface BiomeModificationContext {
    public WeatherContext getWeather();

    public EffectsContext getEffects();

    public GenerationSettingsContext getGenerationSettings();

    public SpawnSettingsContext getSpawnSettings();

    public static interface SpawnSettingsContext {
        public void setCreatureSpawnProbability(float var1);

        public void addSpawn(SpawnGroup var1, SpawnSettings.SpawnEntry var2);

        public boolean removeSpawns(BiPredicate<SpawnGroup, SpawnSettings.SpawnEntry> var1);

        default public boolean removeSpawnsOfEntityType(EntityType<?> entityType) {
            return this.removeSpawns((spawnGroup, spawnEntry) -> spawnEntry.type == entityType);
        }

        default public void clearSpawns(SpawnGroup group) {
            this.removeSpawns((spawnGroup, spawnEntry) -> spawnGroup == group);
        }

        default public void clearSpawns() {
            this.removeSpawns((spawnGroup, spawnEntry) -> true);
        }

        public void setSpawnCost(EntityType<?> var1, double var2, double var4);

        public void clearSpawnCost(EntityType<?> var1);
    }

    public static interface GenerationSettingsContext {
        public boolean removeFeature(GenerationStep.Feature var1, RegistryKey<PlacedFeature> var2);

        default public boolean removeFeature(RegistryKey<PlacedFeature> placedFeatureKey) {
            boolean anyFound = false;
            for (GenerationStep.Feature step : GenerationStep.Feature.values()) {
                if (!this.removeFeature(step, placedFeatureKey)) continue;
                anyFound = true;
            }
            return anyFound;
        }

        public void addFeature(GenerationStep.Feature var1, RegistryKey<PlacedFeature> var2);

        public void addCarver(GenerationStep.Carver var1, RegistryKey<ConfiguredCarver<?>> var2);

        public boolean removeCarver(GenerationStep.Carver var1, RegistryKey<ConfiguredCarver<?>> var2);

        default public boolean removeCarver(RegistryKey<ConfiguredCarver<?>> configuredCarverKey) {
            boolean anyFound = false;
            for (GenerationStep.Carver step : GenerationStep.Carver.values()) {
                if (!this.removeCarver(step, configuredCarverKey)) continue;
                anyFound = true;
            }
            return anyFound;
        }
    }

    public static interface EffectsContext {
        public void setFogColor(int var1);

        public void setWaterColor(int var1);

        public void setWaterFogColor(int var1);

        public void setSkyColor(int var1);

        public void setFoliageColor(Optional<Integer> var1);

        default public void setFoliageColor(int color) {
            this.setFoliageColor(Optional.of(color));
        }

        default public void setFoliageColor(OptionalInt color) {
            color.ifPresentOrElse(this::setFoliageColor, this::clearFoliageColor);
        }

        default public void clearFoliageColor() {
            this.setFoliageColor(Optional.empty());
        }

        public void setGrassColor(Optional<Integer> var1);

        default public void setGrassColor(int color) {
            this.setGrassColor(Optional.of(color));
        }

        default public void setGrassColor(OptionalInt color) {
            color.ifPresentOrElse(this::setGrassColor, this::clearGrassColor);
        }

        default public void clearGrassColor() {
            this.setGrassColor(Optional.empty());
        }

        public void setGrassColorModifier(@NotNull BiomeEffects.GrassColorModifier var1);

        public void setParticleConfig(Optional<BiomeParticleConfig> var1);

        default public void setParticleConfig(@NotNull BiomeParticleConfig particleConfig) {
            this.setParticleConfig(Optional.of(particleConfig));
        }

        default public void clearParticleConfig() {
            this.setParticleConfig(Optional.empty());
        }

        public void setAmbientSound(Optional<RegistryEntry<SoundEvent>> var1);

        default public void setAmbientSound(@NotNull RegistryEntry<SoundEvent> sound) {
            this.setAmbientSound(Optional.of(sound));
        }

        default public void clearAmbientSound() {
            this.setAmbientSound(Optional.empty());
        }

        public void setMoodSound(Optional<BiomeMoodSound> var1);

        default public void setMoodSound(@NotNull BiomeMoodSound sound) {
            this.setMoodSound(Optional.of(sound));
        }

        default public void clearMoodSound() {
            this.setMoodSound(Optional.empty());
        }

        public void setAdditionsSound(Optional<BiomeAdditionsSound> var1);

        default public void setAdditionsSound(@NotNull BiomeAdditionsSound sound) {
            this.setAdditionsSound(Optional.of(sound));
        }

        default public void clearAdditionsSound() {
            this.setAdditionsSound(Optional.empty());
        }

        public void setMusic(Optional<MusicSound> var1);

        default public void setMusic(@NotNull MusicSound sound) {
            this.setMusic(Optional.of(sound));
        }

        default public void clearMusic() {
            this.setMusic(Optional.empty());
        }
    }

    public static interface WeatherContext {
        public void setPrecipitation(boolean var1);

        public void setTemperature(float var1);

        public void setTemperatureModifier(Biome.TemperatureModifier var1);

        public void setDownfall(float var1);
    }
}

