/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.screen;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.Mouse;
import net.minecraft.client.gui.screen.Screen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={Mouse.class})
abstract class MouseMixin {
    @Shadow
    @Final
    private MinecraftClient field_1779;
    @Unique
    private Screen currentScreen;
    @Unique
    private Double horizontalScrollAmount;

    MouseMixin() {
    }

    @Inject(method={"method_1611([ZLnet/minecraft/client/gui/screen/Screen;DDI)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;mouseClicked(DDI)Z")}, cancellable=true)
    private static void beforeMouseClickedEvent(boolean[] resultHack, Screen screen, double mouseX, double mouseY, int button, CallbackInfo ci) {
        MouseMixin thisRef = (MouseMixin)MinecraftClient.getInstance().mouse;
        thisRef.currentScreen = thisRef.field_1779.currentScreen;
        if (thisRef.currentScreen == null) {
            return;
        }
        if (!((ScreenMouseEvents.AllowMouseClick)ScreenMouseEvents.allowMouseClick(thisRef.currentScreen).invoker()).allowMouseClick(thisRef.currentScreen, mouseX, mouseY, button)) {
            resultHack[0] = true;
            thisRef.currentScreen = null;
            ci.cancel();
            return;
        }
        ((ScreenMouseEvents.BeforeMouseClick)ScreenMouseEvents.beforeMouseClick(thisRef.currentScreen).invoker()).beforeMouseClick(thisRef.currentScreen, mouseX, mouseY, button);
    }

    @Inject(method={"method_1611([ZLnet/minecraft/client/gui/screen/Screen;DDI)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;mouseClicked(DDI)Z", shift=At.Shift.AFTER)})
    private static void afterMouseClickedEvent(boolean[] resultHack, Screen screen, double mouseX, double mouseY, int button, CallbackInfo ci) {
        MouseMixin thisRef = (MouseMixin)MinecraftClient.getInstance().mouse;
        if (thisRef.currentScreen == null) {
            return;
        }
        ((ScreenMouseEvents.AfterMouseClick)ScreenMouseEvents.afterMouseClick(thisRef.currentScreen).invoker()).afterMouseClick(thisRef.currentScreen, mouseX, mouseY, button);
        thisRef.currentScreen = null;
    }

    @Inject(method={"method_1605([ZLnet/minecraft/client/gui/screen/Screen;DDI)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;mouseReleased(DDI)Z")}, cancellable=true)
    private static void beforeMouseReleasedEvent(boolean[] resultHack, Screen screen, double mouseX, double mouseY, int button, CallbackInfo ci) {
        MouseMixin thisRef = (MouseMixin)MinecraftClient.getInstance().mouse;
        thisRef.currentScreen = thisRef.field_1779.currentScreen;
        if (thisRef.currentScreen == null) {
            return;
        }
        if (!((ScreenMouseEvents.AllowMouseRelease)ScreenMouseEvents.allowMouseRelease(thisRef.currentScreen).invoker()).allowMouseRelease(thisRef.currentScreen, mouseX, mouseY, button)) {
            resultHack[0] = true;
            thisRef.currentScreen = null;
            ci.cancel();
            return;
        }
        ((ScreenMouseEvents.BeforeMouseRelease)ScreenMouseEvents.beforeMouseRelease(thisRef.currentScreen).invoker()).beforeMouseRelease(thisRef.currentScreen, mouseX, mouseY, button);
    }

    @Inject(method={"method_1605([ZLnet/minecraft/client/gui/screen/Screen;DDI)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;mouseReleased(DDI)Z", shift=At.Shift.AFTER)})
    private static void afterMouseReleasedEvent(boolean[] resultHack, Screen screen, double mouseX, double mouseY, int button, CallbackInfo ci) {
        MouseMixin thisRef = (MouseMixin)MinecraftClient.getInstance().mouse;
        if (thisRef.currentScreen == null) {
            return;
        }
        ((ScreenMouseEvents.AfterMouseRelease)ScreenMouseEvents.afterMouseRelease(thisRef.currentScreen).invoker()).afterMouseRelease(thisRef.currentScreen, mouseX, mouseY, button);
        thisRef.currentScreen = null;
    }

    @Inject(method={"onMouseScroll"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;mouseScrolled(DDD)Z")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, cancellable=true)
    private void beforeMouseScrollEvent(long window, double horizontal, double vertical, CallbackInfo ci, double verticalAmount, double mouseX, double mouseY) {
        this.currentScreen = this.field_1779.currentScreen;
        if (this.currentScreen == null) {
            return;
        }
        this.horizontalScrollAmount = (Boolean)this.field_1779.options.getDiscreteMouseScroll().getValue() != false ? Math.signum(horizontal) : horizontal * (Double)this.field_1779.options.getMouseWheelSensitivity().getValue();
        if (!((ScreenMouseEvents.AllowMouseScroll)ScreenMouseEvents.allowMouseScroll(this.currentScreen).invoker()).allowMouseScroll(this.currentScreen, mouseX, mouseY, this.horizontalScrollAmount, verticalAmount)) {
            this.currentScreen = null;
            this.horizontalScrollAmount = null;
            ci.cancel();
            return;
        }
        ((ScreenMouseEvents.BeforeMouseScroll)ScreenMouseEvents.beforeMouseScroll(this.currentScreen).invoker()).beforeMouseScroll(this.currentScreen, mouseX, mouseY, this.horizontalScrollAmount, verticalAmount);
    }

    @Inject(method={"onMouseScroll"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;mouseScrolled(DDD)Z", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private void afterMouseScrollEvent(long window, double horizontal, double vertical, CallbackInfo ci, double verticalAmount, double mouseX, double mouseY) {
        if (this.currentScreen == null) {
            return;
        }
        ((ScreenMouseEvents.AfterMouseScroll)ScreenMouseEvents.afterMouseScroll(this.currentScreen).invoker()).afterMouseScroll(this.currentScreen, mouseX, mouseY, this.horizontalScrollAmount, verticalAmount);
        this.currentScreen = null;
        this.horizontalScrollAmount = null;
    }
}

