/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.attachment;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ChunkSerializer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ProtoChunk;
import net.minecraft.world.chunk.WorldChunk;
import net.minecraft.world.poi.PointOfInterestStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
abstract class ChunkSerializerMixin {
    ChunkSerializerMixin() {
    }

    @ModifyExpressionValue(at={@At(value="NEW", target="net/minecraft/world/chunk/WorldChunk")}, method={"deserialize"})
    private static WorldChunk readWorldChunkAttachments(WorldChunk chunk, ServerWorld world, PointOfInterestStorage poiStorage, ChunkPos chunkPos, NbtCompound nbt) {
        ((AttachmentTargetImpl)chunk).fabric_readAttachmentsFromNbt(nbt);
        return chunk;
    }

    @ModifyExpressionValue(at={@At(value="NEW", target="net/minecraft/world/chunk/ProtoChunk")}, method={"deserialize"})
    private static ProtoChunk readProtoChunkAttachments(ProtoChunk chunk, ServerWorld world, PointOfInterestStorage poiStorage, ChunkPos chunkPos, NbtCompound nbt) {
        ((AttachmentTargetImpl)chunk).fabric_readAttachmentsFromNbt(nbt);
        return chunk;
    }

    @Inject(at={@At(value="RETURN")}, method={"serialize"})
    private static void writeChunkAttachments(ServerWorld world, Chunk chunk, CallbackInfoReturnable<NbtCompound> cir) {
        ((AttachmentTargetImpl)chunk).fabric_writeAttachmentsToNbt((NbtCompound)cir.getReturnValue());
    }
}

