/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.attachment;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentEntrypoint;
import net.fabricmc.fabric.impl.attachment.AttachmentSerializingImpl;
import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BlockEntity.class, Entity.class, World.class, Chunk.class})
abstract class AttachmentTargetsMixin
implements AttachmentTargetImpl {
    @Nullable
    private IdentityHashMap<AttachmentType<?>, Object> fabric_dataAttachments = null;

    AttachmentTargetsMixin() {
    }

    @Nullable
    public <T> T getAttached(AttachmentType<T> type) {
        return (T)(this.fabric_dataAttachments == null ? null : this.fabric_dataAttachments.get(type));
    }

    @Nullable
    public <T> T setAttached(AttachmentType<T> type, @Nullable T value) {
        AttachmentTargetsMixin thisObject = this;
        if (thisObject instanceof BlockEntity) {
            ((BlockEntity)thisObject).markDirty();
        } else if (thisObject instanceof Chunk) {
            ((Chunk)thisObject).setNeedsSaving(true);
            if (type.isPersistent() && ((Chunk)thisObject).getStatus().equals(ChunkStatus.EMPTY)) {
                AttachmentEntrypoint.LOGGER.warn("Attaching persistent attachment {} to chunk with chunk status EMPTY. Attachment might be discarded.", (Object)type.identifier());
            }
        }
        if (value == null) {
            if (this.fabric_dataAttachments == null) {
                return null;
            }
            Object removed = this.fabric_dataAttachments.remove(type);
            if (this.fabric_dataAttachments.isEmpty()) {
                this.fabric_dataAttachments = null;
            }
            return (T)removed;
        }
        if (this.fabric_dataAttachments == null) {
            this.fabric_dataAttachments = new IdentityHashMap();
        }
        return (T)this.fabric_dataAttachments.put(type, value);
    }

    @Override
    public boolean hasAttached(AttachmentType<?> type) {
        return this.fabric_dataAttachments != null && this.fabric_dataAttachments.containsKey(type);
    }

    @Override
    public void fabric_writeAttachmentsToNbt(NbtCompound nbt) {
        AttachmentSerializingImpl.serializeAttachmentData(nbt, this.fabric_dataAttachments);
    }

    @Override
    public void fabric_readAttachmentsFromNbt(NbtCompound nbt) {
        this.fabric_dataAttachments = AttachmentSerializingImpl.deserializeAttachmentData(nbt);
    }

    @Override
    public boolean fabric_hasPersistentAttachments() {
        return AttachmentSerializingImpl.hasPersistentAttachments(this.fabric_dataAttachments);
    }

    @Override
    public Map<AttachmentType<?>, ?> fabric_getAttachments() {
        return this.fabric_dataAttachments;
    }
}

