/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentRegistryImpl;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtElement;
import net.minecraft.nbt.NbtOps;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentSerializingImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-data-attachment-api-v1");

    public static void serializeAttachmentData(NbtCompound nbt, @Nullable IdentityHashMap<AttachmentType<?>, ?> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        NbtCompound compound = new NbtCompound();
        for (Map.Entry<AttachmentType<?>, ?> entry : attachments.entrySet()) {
            AttachmentType<?> type = entry.getKey();
            Codec<?> codec = type.persistenceCodec();
            if (codec == null) continue;
            codec.encodeStart((DynamicOps)NbtOps.INSTANCE, entry.getValue()).get().ifRight(partial -> {
                LOGGER.warn("Couldn't serialize attachment " + String.valueOf(type.identifier()) + ", skipping. Error:");
                LOGGER.warn(partial.message());
            }).ifLeft(serialized -> compound.put(type.identifier().toString(), serialized));
        }
        nbt.put("fabric:attachments", (NbtElement)compound);
    }

    @Nullable
    public static IdentityHashMap<AttachmentType<?>, Object> deserializeAttachmentData(NbtCompound nbt) {
        if (nbt.contains("fabric:attachments", 10)) {
            IdentityHashMap attachments = new IdentityHashMap();
            NbtCompound compound = nbt.getCompound("fabric:attachments");
            for (String key : compound.getKeys()) {
                AttachmentType<?> type = AttachmentRegistryImpl.get(new Identifier(key));
                if (type == null) {
                    LOGGER.warn("Unknown attachment type " + key + " found when deserializing, skipping");
                    continue;
                }
                Codec<?> codec = type.persistenceCodec();
                if (codec == null) continue;
                codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get(key)).get().ifRight(partial -> {
                    LOGGER.warn("Couldn't deserialize attachment " + String.valueOf(type.identifier()) + ", skipping. Error:");
                    LOGGER.warn(partial.message());
                }).ifLeft(deserialized -> attachments.put(type, deserialized));
            }
            if (attachments.isEmpty()) {
                return null;
            }
            return attachments;
        }
        return null;
    }

    public static boolean hasPersistentAttachments(@Nullable IdentityHashMap<AttachmentType<?>, ?> map) {
        if (map == null) {
            return false;
        }
        for (AttachmentType<?> type : map.keySet()) {
            if (!type.isPersistent()) continue;
            return true;
        }
        return false;
    }
}

