/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import net.fabricmc.fabric.impl.attachment.AttachmentTargetImpl;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.world.PersistentState;
import org.jetbrains.annotations.Nullable;

public class AttachmentPersistentState
extends PersistentState {
    public static final String ID = "fabric_attachments";
    private final AttachmentTargetImpl worldTarget;
    private final boolean wasSerialized;

    public AttachmentPersistentState(ServerWorld world) {
        this.worldTarget = (AttachmentTargetImpl)world;
        this.wasSerialized = this.worldTarget.fabric_hasPersistentAttachments();
    }

    public static AttachmentPersistentState read(ServerWorld world, @Nullable NbtCompound nbt) {
        ((AttachmentTargetImpl)world).fabric_readAttachmentsFromNbt(nbt);
        return new AttachmentPersistentState(world);
    }

    public boolean isDirty() {
        return this.wasSerialized || this.worldTarget.fabric_hasPersistentAttachments();
    }

    public NbtCompound writeNbt(NbtCompound nbt) {
        this.worldTarget.fabric_writeAttachmentsToNbt(nbt);
        return nbt;
    }
}

