/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.gamerule.v1;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.gamerule.v1.FabricGameRuleVisitor;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.impl.gamerule.EnumRuleType;
import net.fabricmc.fabric.impl.gamerule.rule.BoundedIntRule;
import net.fabricmc.fabric.mixin.gamerule.GameRulesBooleanRuleAccessor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import org.jetbrains.annotations.Nullable;

public final class GameRuleFactory {
    public static GameRules.Type<GameRules.BooleanRule> createBooleanRule(boolean defaultValue) {
        return GameRuleFactory.createBooleanRule(defaultValue, (server, rule) -> {});
    }

    public static GameRules.Type<GameRules.BooleanRule> createBooleanRule(boolean defaultValue, BiConsumer<MinecraftServer, GameRules.BooleanRule> changedCallback) {
        return GameRulesBooleanRuleAccessor.invokeCreate(defaultValue, changedCallback);
    }

    public static GameRules.Type<GameRules.IntRule> createIntRule(int defaultValue) {
        return GameRuleFactory.createIntRule(defaultValue, (server, rule) -> {});
    }

    public static GameRules.Type<GameRules.IntRule> createIntRule(int defaultValue, int minimumValue) {
        return GameRuleFactory.createIntRule(defaultValue, minimumValue, Integer.MAX_VALUE, (server, rule) -> {});
    }

    public static GameRules.Type<GameRules.IntRule> createIntRule(int defaultValue, int minimumValue, BiConsumer<MinecraftServer, GameRules.IntRule> changedCallback) {
        return GameRuleFactory.createIntRule(defaultValue, minimumValue, Integer.MAX_VALUE, changedCallback);
    }

    public static GameRules.Type<GameRules.IntRule> createIntRule(int defaultValue, int minimumValue, int maximumValue) {
        return GameRuleFactory.createIntRule(defaultValue, minimumValue, maximumValue, (server, rule) -> {});
    }

    public static GameRules.Type<GameRules.IntRule> createIntRule(int defaultValue, BiConsumer<MinecraftServer, GameRules.IntRule> changedCallback) {
        return GameRuleFactory.createIntRule(defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, changedCallback);
    }

    public static GameRules.Type<GameRules.IntRule> createIntRule(int defaultValue, int minimumValue, int maximumValue, @Nullable BiConsumer<MinecraftServer, GameRules.IntRule> changedCallback) {
        return new GameRules.Type(() -> IntegerArgumentType.integer((int)minimumValue, (int)maximumValue), type -> new BoundedIntRule((GameRules.Type<GameRules.IntRule>)type, defaultValue, minimumValue, maximumValue), changedCallback, GameRules.Visitor::visitInt);
    }

    public static GameRules.Type<DoubleRule> createDoubleRule(double defaultValue) {
        return GameRuleFactory.createDoubleRule(defaultValue, (server, rule) -> {});
    }

    public static GameRules.Type<DoubleRule> createDoubleRule(double defaultValue, double minimumValue) {
        return GameRuleFactory.createDoubleRule(defaultValue, minimumValue, Double.MAX_VALUE, (server, rule) -> {});
    }

    public static GameRules.Type<DoubleRule> createDoubleRule(double defaultValue, double minimumValue, BiConsumer<MinecraftServer, DoubleRule> changedCallback) {
        return GameRuleFactory.createDoubleRule(defaultValue, minimumValue, Double.MAX_VALUE, changedCallback);
    }

    public static GameRules.Type<DoubleRule> createDoubleRule(double defaultValue, double minimumValue, double maximumValue) {
        return GameRuleFactory.createDoubleRule(defaultValue, minimumValue, maximumValue, (server, rule) -> {});
    }

    public static GameRules.Type<DoubleRule> createDoubleRule(double defaultValue, BiConsumer<MinecraftServer, DoubleRule> changedCallback) {
        return GameRuleFactory.createDoubleRule(defaultValue, Double.MIN_VALUE, Double.MAX_VALUE, changedCallback);
    }

    public static GameRules.Type<DoubleRule> createDoubleRule(double defaultValue, double minimumValue, double maximumValue, BiConsumer<MinecraftServer, DoubleRule> changedCallback) {
        return new GameRules.Type(() -> DoubleArgumentType.doubleArg((double)minimumValue, (double)maximumValue), type -> new DoubleRule((GameRules.Type<DoubleRule>)type, defaultValue, minimumValue, maximumValue), changedCallback, GameRuleFactory::visitDouble);
    }

    public static <E extends Enum<E>> GameRules.Type<EnumRule<E>> createEnumRule(E defaultValue) {
        return GameRuleFactory.createEnumRule(defaultValue, (server, rule) -> {});
    }

    public static <E extends Enum<E>> GameRules.Type<EnumRule<E>> createEnumRule(E defaultValue, BiConsumer<MinecraftServer, EnumRule<E>> changedCallback) {
        return GameRuleFactory.createEnumRule(defaultValue, (Enum[])((Enum[])defaultValue.getDeclaringClass().getEnumConstants()), changedCallback);
    }

    public static <E extends Enum<E>> GameRules.Type<EnumRule<E>> createEnumRule(E defaultValue, E[] supportedValues) {
        return GameRuleFactory.createEnumRule(defaultValue, supportedValues, (T server, U rule) -> {});
    }

    public static <E extends Enum<E>> GameRules.Type<EnumRule<E>> createEnumRule(E defaultValue, E[] supportedValues, BiConsumer<MinecraftServer, EnumRule<E>> changedCallback) {
        Preconditions.checkNotNull(defaultValue, (Object)"Default rule value cannot be null");
        Preconditions.checkNotNull(supportedValues, (Object)"Supported Values cannot be null");
        if (supportedValues.length == 0) {
            throw new IllegalArgumentException("Cannot register an enum rule where no values are supported");
        }
        return new EnumRuleType(type -> new EnumRule(type, defaultValue, supportedValues), changedCallback, supportedValues, GameRuleFactory::visitEnum);
    }

    private static void visitDouble(GameRules.Visitor visitor, GameRules.Key<DoubleRule> key, GameRules.Type<DoubleRule> type) {
        if (visitor instanceof FabricGameRuleVisitor) {
            ((FabricGameRuleVisitor)visitor).visitDouble(key, type);
        }
    }

    private static <E extends Enum<E>> void visitEnum(GameRules.Visitor visitor, GameRules.Key<EnumRule<E>> key, GameRules.Type<EnumRule<E>> type) {
        if (visitor instanceof FabricGameRuleVisitor) {
            ((FabricGameRuleVisitor)visitor).visitEnum(key, type);
        }
    }

    private GameRuleFactory() {
    }
}

