/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.blockview.client;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.blockview.client.RenderDataMapConsumer;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.client.render.chunk.ChunkRendererRegion;
import net.minecraft.client.render.chunk.ChunkRendererRegionBuilder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.WorldChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ChunkRendererRegionBuilder.class})
public abstract class ChunkRendererRegionBuilderMixin {
    private static final AtomicInteger ERROR_COUNTER = new AtomicInteger();
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkRendererRegionBuilderMixin.class);

    @Inject(method={"build"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void createDataMap(World world, BlockPos startPos, BlockPos endPos, int offset, CallbackInfoReturnable<ChunkRendererRegion> cir, int startX, int startZ, int endX, int endZ, ChunkRendererRegionBuilder.ClientChunk[][] chunksXZ) {
        ChunkRendererRegion rendererRegion = (ChunkRendererRegion)cir.getReturnValue();
        if (rendererRegion == null) {
            return;
        }
        Long2ObjectOpenHashMap<Object> map = null;
        ChunkRendererRegionBuilder.ClientChunk[][] clientChunkArray = chunksXZ;
        int n = clientChunkArray.length;
        for (int i = 0; i < n; ++i) {
            ChunkRendererRegionBuilder.ClientChunk[] chunksZ;
            block3: for (ChunkRendererRegionBuilder.ClientChunk chunk : chunksZ = clientChunkArray[i]) {
                while (true) {
                    try {
                        map = ChunkRendererRegionBuilderMixin.mapChunk(chunk.getChunk(), startPos, endPos, map);
                        continue block3;
                    }
                    catch (ConcurrentModificationException e) {
                        int count = ERROR_COUNTER.incrementAndGet();
                        if (count > 5) continue;
                        LOGGER.warn("[Block Entity Render Data] Encountered CME during render region build. A mod is accessing or changing chunk data outside the main thread. Retrying.", (Throwable)e);
                        if (count != 5) continue;
                        LOGGER.info("[Block Entity Render Data] Subsequent exceptions will be suppressed.");
                        continue;
                    }
                    break;
                }
            }
        }
        if (map != null) {
            ((RenderDataMapConsumer)rendererRegion).fabric_acceptRenderDataMap((Long2ObjectMap<Object>)map);
        }
    }

    @Unique
    private static Long2ObjectOpenHashMap<Object> mapChunk(WorldChunk chunk, BlockPos posFrom, BlockPos posTo, Long2ObjectOpenHashMap<Object> map) {
        int xMin = posFrom.getX();
        int xMax = posTo.getX();
        int yMin = posFrom.getY();
        int yMax = posTo.getY();
        int zMin = posFrom.getZ();
        int zMax = posTo.getZ();
        for (Map.Entry entry : chunk.getBlockEntities().entrySet()) {
            Object data;
            BlockPos pos = (BlockPos)entry.getKey();
            if (pos.getX() < xMin || pos.getX() > xMax || pos.getY() < yMin || pos.getY() > yMax || pos.getZ() < zMin || pos.getZ() > zMax || (data = ((BlockEntity)entry.getValue()).getRenderData()) == null) continue;
            if (map == null) {
                map = new Long2ObjectOpenHashMap();
            }
            map.put(pos.asLong(), data);
        }
        return map;
    }
}

