/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.fabricmc.fabric.impl.gamerule.EnumRuleType;
import net.fabricmc.fabric.mixin.gamerule.GameRuleCommandAccessor;
import net.minecraft.server.command.CommandManager;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.text.Text;
import net.minecraft.world.GameRules;

public final class EnumRuleCommand {
    public static <E extends Enum<E>> void register(LiteralArgumentBuilder<ServerCommandSource> literalArgumentBuilder, GameRules.Key<EnumRule<E>> key, EnumRuleType<E> type) {
        literalArgumentBuilder.then(CommandManager.literal((String)key.getName()).executes(context -> GameRuleCommandAccessor.invokeExecuteQuery((ServerCommandSource)context.getSource(), key)));
        type.register(literalArgumentBuilder, key);
    }

    public static <E extends Enum<E>> int executeAndSetEnum(CommandContext<ServerCommandSource> context, E value, GameRules.Key<EnumRule<E>> key) throws CommandSyntaxException {
        ServerCommandSource serverCommandSource = (ServerCommandSource)context.getSource();
        EnumRule rule = (EnumRule)serverCommandSource.getServer().getGameRules().get(key);
        try {
            rule.set(value, serverCommandSource.getServer());
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)Text.literal((String)e.getMessage())).create();
        }
        serverCommandSource.sendFeedback(() -> Text.translatable((String)"commands.gamerule.set", (Object[])new Object[]{key.getName(), rule.toString()}), true);
        return rule.getCommandResult();
    }
}

