/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.gamerule.v1.rule;

import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.gamerule.v1.rule.ValidateableRule;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.command.ServerCommandSource;
import net.minecraft.world.GameRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DoubleRule
extends GameRules.Rule<DoubleRule>
implements ValidateableRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GameRuleRegistry.class);
    private final double minimumValue;
    private final double maximumValue;
    private double value;

    @Deprecated
    public DoubleRule(GameRules.Type<DoubleRule> type, double value, double minimumValue, double maximumValue) {
        super(type);
        this.value = value;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new IllegalArgumentException("Value cannot be infinite or NaN");
        }
        if (Double.isInfinite(minimumValue) || Double.isNaN(minimumValue)) {
            throw new IllegalArgumentException("Minimum value cannot be infinite or NaN");
        }
        if (Double.isInfinite(maximumValue) || Double.isNaN(maximumValue)) {
            throw new IllegalArgumentException("Maximum value cannot be infinite or NaN");
        }
    }

    protected void setFromArgument(CommandContext<ServerCommandSource> context, String name) {
        this.value = (Double)context.getArgument(name, Double.class);
    }

    protected void deserialize(String value) {
        if (!value.isEmpty()) {
            try {
                double d = Double.parseDouble(value);
                if (this.inBounds(d)) {
                    this.value = d;
                } else {
                    LOGGER.warn("Failed to parse double {}. Was out of bounds {} - {}", new Object[]{value, this.minimumValue, this.maximumValue});
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse double {}", (Object)value);
            }
        }
    }

    public String serialize() {
        return Double.toString(this.value);
    }

    public int getCommandResult() {
        return Double.compare(this.value, 0.0);
    }

    protected DoubleRule getThis() {
        return this;
    }

    protected DoubleRule copy() {
        return new DoubleRule((GameRules.Type<DoubleRule>)this.type, this.value, this.minimumValue, this.maximumValue);
    }

    public void setValue(DoubleRule rule, MinecraftServer minecraftServer) {
        if (!this.inBounds(rule.value)) {
            throw new IllegalArgumentException(String.format("Could not set value to %s. Was out of bounds %s - %s", rule.value, this.minimumValue, this.maximumValue));
        }
        this.value = rule.value;
        this.changed(minecraftServer);
    }

    @Override
    public boolean validate(String value) {
        try {
            double d = Double.parseDouble(value);
            if (!this.inBounds(d)) {
                return false;
            }
            this.value = d;
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public double get() {
        return this.value;
    }

    private boolean inBounds(double value) {
        return value >= this.minimumValue && value <= this.maximumValue;
    }
}

