/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.render.model.MultipartBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.random.Random;
import net.minecraft.world.BlockRenderView;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MultipartBakedModel.class})
public class MultipartBakedModelMixin
implements FabricBakedModel {
    @Shadow
    @Final
    private List<Pair<Predicate<BlockState>, BakedModel>> field_5427;
    @Shadow
    @Final
    private Map<BlockState, BitSet> field_5431;
    @Unique
    boolean isVanilla = true;

    @Override
    public boolean isVanillaAdapter() {
        return this.isVanilla;
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void onInit(List<Pair<Predicate<BlockState>, BakedModel>> components, CallbackInfo cb) {
        for (Pair<Predicate<BlockState>, BakedModel> component : components) {
            if (((BakedModel)component.getRight()).isVanillaAdapter()) continue;
            this.isVanilla = false;
            break;
        }
    }

    @Override
    public void emitBlockQuads(BlockRenderView blockView, BlockState state, BlockPos pos, Supplier<Random> randomSupplier, RenderContext context) {
        BitSet bitSet = this.field_5431.get(state);
        if (bitSet == null) {
            bitSet = new BitSet();
            for (int i = 0; i < this.field_5427.size(); ++i) {
                Pair<Predicate<BlockState>, BakedModel> pair = this.field_5427.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitSet.set(i);
            }
            this.field_5431.put(state, bitSet);
        }
        Random random = randomSupplier.get();
        long randomSeed = random.nextLong();
        Supplier<Random> subModelRandomSupplier = () -> {
            random.setSeed(randomSeed);
            return random;
        };
        for (int i = 0; i < this.field_5427.size(); ++i) {
            if (!bitSet.get(i)) continue;
            ((BakedModel)this.field_5427.get(i).getRight()).emitBlockQuads(blockView, state, pos, subModelRandomSupplier, context);
        }
    }

    @Override
    public void emitItemQuads(ItemStack stack, Supplier<Random> randomSupplier, RenderContext context) {
    }
}

