/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.dimension;

import net.fabricmc.fabric.impl.dimension.Teleportable;
import net.minecraft.entity.Entity;
import net.minecraft.registry.RegistryKey;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.world.TeleportTarget;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerEntity.class, Entity.class})
public class EntityMixin
implements Teleportable {
    @Unique
    @Nullable
    protected TeleportTarget customTeleportTarget;

    @Override
    public void fabric_setCustomTeleportTarget(TeleportTarget teleportTarget) {
        this.customTeleportTarget = teleportTarget;
    }

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void getTeleportTarget(ServerWorld destination, CallbackInfoReturnable<TeleportTarget> cir) {
        TeleportTarget customTarget = this.customTeleportTarget;
        if (customTarget != null) {
            cir.setReturnValue((Object)customTarget);
        }
    }

    @Redirect(method={"moveToWorld"}, at=@At(value="FIELD", target="Lnet/minecraft/world/World;END:Lnet/minecraft/registry/RegistryKey;"))
    private RegistryKey<World> stopEndSpecificBehavior() {
        if (this.customTeleportTarget != null) {
            return null;
        }
        return World.END;
    }
}

