/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.particle;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.impl.client.particle.FabricSpriteProviderImpl;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.minecraft.client.particle.ParticleFactory;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.particle.SpriteProvider;
import net.minecraft.particle.ParticleEffect;
import net.minecraft.particle.ParticleType;
import net.minecraft.registry.Registries;

@Environment(value=EnvType.CLIENT)
public final class ParticleFactoryRegistryImpl
implements ParticleFactoryRegistry {
    public static final ParticleFactoryRegistryImpl INSTANCE = new ParticleFactoryRegistryImpl();
    ParticleFactoryRegistry internalRegistry = new DeferredParticleFactoryRegistry();

    private ParticleFactoryRegistryImpl() {
    }

    @Override
    public <T extends ParticleEffect> void register(ParticleType<T> type, ParticleFactory<T> factory) {
        this.internalRegistry.register(type, factory);
    }

    @Override
    public <T extends ParticleEffect> void register(ParticleType<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
        this.internalRegistry.register(type, constructor);
    }

    public void initialize(ParticleManager particleManager) {
        DirectParticleFactoryRegistry newRegistry = new DirectParticleFactoryRegistry(particleManager);
        DeferredParticleFactoryRegistry oldRegistry = (DeferredParticleFactoryRegistry)this.internalRegistry;
        oldRegistry.applyTo(newRegistry);
        this.internalRegistry = newRegistry;
    }

    @Environment(value=EnvType.CLIENT)
    static class DeferredParticleFactoryRegistry
    implements ParticleFactoryRegistry {
        private final Map<ParticleType<?>, ParticleFactory<?>> factories = new IdentityHashMap();
        private final Map<ParticleType<?>, ParticleFactoryRegistry.PendingParticleFactory<?>> constructors = new IdentityHashMap();

        DeferredParticleFactoryRegistry() {
        }

        @Override
        public <T extends ParticleEffect> void register(ParticleType<T> type, ParticleFactory<T> factory) {
            this.factories.put(type, factory);
        }

        @Override
        public <T extends ParticleEffect> void register(ParticleType<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> factory) {
            this.constructors.put(type, factory);
        }

        void applyTo(ParticleFactoryRegistry registry) {
            ParticleType<?> type;
            for (Map.Entry<ParticleType<?>, ParticleFactory<?>> entry : this.factories.entrySet()) {
                type = entry.getKey();
                ParticleFactory<?> factory = entry.getValue();
                registry.register(type, factory);
            }
            for (Map.Entry<ParticleType<?>, Object> entry : this.constructors.entrySet()) {
                type = entry.getKey();
                ParticleFactoryRegistry.PendingParticleFactory constructor = (ParticleFactoryRegistry.PendingParticleFactory)entry.getValue();
                registry.register(type, constructor);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class DirectParticleFactoryRegistry
    implements ParticleFactoryRegistry {
        private final ParticleManager particleManager;

        DirectParticleFactoryRegistry(ParticleManager particleManager) {
            this.particleManager = particleManager;
        }

        @Override
        public <T extends ParticleEffect> void register(ParticleType<T> type, ParticleFactory<T> factory) {
            ((ParticleManagerAccessor)this.particleManager).getFactories().put(Registries.PARTICLE_TYPE.getRawId(type), factory);
        }

        @Override
        public <T extends ParticleEffect> void register(ParticleType<T> type, ParticleFactoryRegistry.PendingParticleFactory<T> constructor) {
            ParticleManager.SimpleSpriteProvider delegate = new ParticleManager.SimpleSpriteProvider();
            FabricSpriteProviderImpl fabricSpriteProvider = new FabricSpriteProviderImpl(this.particleManager, (SpriteProvider)delegate);
            ((ParticleManagerAccessor)this.particleManager).getSpriteAwareFactories().put(Registries.PARTICLE_TYPE.getId(type), (SpriteProvider)delegate);
            this.register(type, constructor.create(fabricSpriteProvider));
        }
    }
}

