/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.transfer;

import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.impl.transfer.TransferApiImpl;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.DropperBlock;
import net.minecraft.block.entity.DispenserBlockEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DropperBlock.class})
public class DropperBlockMixin {
    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/block/dispenser/DispenserBehavior;dispense(Lnet/minecraft/util/math/BlockPointer;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")}, method={"dispense"}, cancellable=true, allow=1)
    public void hookDispense(ServerWorld world, BlockPos pos, CallbackInfo ci) {
        DispenserBlockEntity dispenser = (DispenserBlockEntity)world.getBlockEntity(pos);
        Direction direction = (Direction)dispenser.getCachedState().get((Property)DispenserBlock.FACING);
        Storage target = (Storage)ItemStorage.SIDED.find((World)world, pos.offset(direction), (Object)direction.getOpposite());
        if (target != null) {
            ci.cancel();
            int slot = dispenser.chooseNonEmptySlot(world.random);
            if (slot == -1) {
                TransferApiImpl.LOGGER.warn("Skipping dropper transfer because the empty slot is unexpectedly -1.");
                return;
            }
            StorageUtil.move(InventoryStorage.of((Inventory)dispenser, null).getSlot(slot), target, k -> true, 1L, null);
        }
    }
}

