/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer;

import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public final class DebugMessages {
    public static String forGlobalPos(@Nullable World world, BlockPos pos) {
        String dimension = world != null ? world.getDimensionKey().getValue().toString() : "<no dimension>";
        return dimension + "@" + pos.toShortString();
    }

    public static String forPlayer(PlayerEntity player) {
        return player.getEntityName() + "/" + player.getUuidAsString();
    }

    public static String forInventory(@Nullable Inventory inventory) {
        if (inventory == null) {
            return "~~NULL~~";
        }
        if (inventory instanceof PlayerInventory) {
            PlayerInventory playerInventory = (PlayerInventory)inventory;
            return DebugMessages.forPlayer(playerInventory.player);
        }
        Object result = inventory.toString();
        if (inventory instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)inventory;
            result = (String)result + " (%s, %s)".formatted(blockEntity.getCachedState(), DebugMessages.forGlobalPos(blockEntity.getWorld(), blockEntity.getPos()));
        }
        return result;
    }
}

