/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.item;

import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.inventory.Inventory;
import net.minecraft.util.math.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface InventoryStorage
extends SlottedStorage<ItemVariant> {
    public static InventoryStorage of(Inventory inventory, @Nullable Direction direction) {
        Objects.requireNonNull(inventory, "Null inventory is not supported.");
        return InventoryStorageImpl.of(inventory, direction);
    }

    @Override
    public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getSlots();

    @Override
    default public int getSlotCount() {
        return this.getSlots().size();
    }

    @Override
    default public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.getSlots().get(slot);
    }
}

