/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.fluid;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.registry.Registries;
import net.minecraft.sound.SoundEvent;
import net.minecraft.text.Text;
import net.minecraft.util.Identifier;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface FluidVariantAttributeHandler {
    default public Text getName(FluidVariant fluidVariant) {
        Block fluidBlock = fluidVariant.getFluid().getDefaultState().getBlockState().getBlock();
        if (!fluidVariant.isBlank() && fluidBlock == Blocks.AIR) {
            return Text.translatable((String)Util.createTranslationKey((String)"block", (Identifier)Registries.FLUID.getId((Object)fluidVariant.getFluid())));
        }
        return fluidBlock.getName();
    }

    default public Optional<SoundEvent> getFillSound(FluidVariant variant) {
        return Optional.empty();
    }

    default public Optional<SoundEvent> getEmptySound(FluidVariant variant) {
        return Optional.empty();
    }

    default public int getLuminance(FluidVariant variant) {
        return variant.getFluid().getDefaultState().getBlockState().getLuminance();
    }

    default public int getTemperature(FluidVariant variant) {
        return 300;
    }

    default public int getViscosity(FluidVariant variant, @Nullable World world) {
        return 1000;
    }

    default public boolean isLighterThanAir(FluidVariant variant) {
        return false;
    }
}

