/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.client.fluid;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.lookup.v1.custom.ApiProviderMap;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.item.TooltipContext;
import net.minecraft.client.texture.Sprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.registry.Registries;
import net.minecraft.text.Text;
import net.minecraft.util.Formatting;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BlockRenderView;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Experimental
public final class FluidVariantRendering {
    private static final ApiProviderMap<Fluid, FluidVariantRenderHandler> HANDLERS = ApiProviderMap.create();
    private static final FluidVariantRenderHandler DEFAULT_HANDLER = new FluidVariantRenderHandler(){};

    private FluidVariantRendering() {
    }

    public static void register(Fluid fluid, FluidVariantRenderHandler handler) {
        if (HANDLERS.putIfAbsent((Object)fluid, (Object)handler) != null) {
            throw new IllegalArgumentException("Duplicate handler registration for fluid " + String.valueOf(fluid));
        }
    }

    @Nullable
    public static FluidVariantRenderHandler getHandler(Fluid fluid) {
        return (FluidVariantRenderHandler)HANDLERS.get((Object)fluid);
    }

    public static FluidVariantRenderHandler getHandlerOrDefault(Fluid fluid) {
        FluidVariantRenderHandler handler = (FluidVariantRenderHandler)HANDLERS.get((Object)fluid);
        return handler == null ? DEFAULT_HANDLER : handler;
    }

    public static List<Text> getTooltip(FluidVariant fluidVariant) {
        return FluidVariantRendering.getTooltip(fluidVariant, (TooltipContext)(MinecraftClient.getInstance().options.advancedItemTooltips ? TooltipContext.Default.ADVANCED : TooltipContext.Default.BASIC));
    }

    public static List<Text> getTooltip(FluidVariant fluidVariant, TooltipContext context) {
        ArrayList<Text> tooltip = new ArrayList<Text>();
        tooltip.add(FluidVariantAttributes.getName(fluidVariant));
        FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).appendTooltip(fluidVariant, tooltip, context);
        if (context.isAdvanced()) {
            tooltip.add((Text)Text.literal((String)Registries.FLUID.getId((Object)fluidVariant.getFluid()).toString()).formatted(Formatting.DARK_GRAY));
        }
        return tooltip;
    }

    @Nullable
    public static Sprite[] getSprites(FluidVariant fluidVariant) {
        return FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).getSprites(fluidVariant);
    }

    @Nullable
    public static Sprite getSprite(FluidVariant fluidVariant) {
        Sprite[] sprites = FluidVariantRendering.getSprites(fluidVariant);
        return sprites != null ? Objects.requireNonNull(sprites[0]) : null;
    }

    public static int getColor(FluidVariant fluidVariant) {
        return FluidVariantRendering.getColor(fluidVariant, null, null);
    }

    public static int getColor(FluidVariant fluidVariant, @Nullable BlockRenderView view, @Nullable BlockPos pos) {
        return FluidVariantRendering.getHandlerOrDefault(fluidVariant.getFluid()).getColor(fluidVariant, view, pos);
    }
}

