/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome.modification;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnGroup;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.entry.RegistryEntryList;
import net.minecraft.sound.BiomeAdditionsSound;
import net.minecraft.sound.BiomeMoodSound;
import net.minecraft.sound.MusicSound;
import net.minecraft.sound.SoundEvent;
import net.minecraft.util.collection.Pool;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEffects;
import net.minecraft.world.biome.BiomeParticleConfig;
import net.minecraft.world.biome.GenerationSettings;
import net.minecraft.world.biome.SpawnSettings;
import net.minecraft.world.gen.GenerationStep;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.PlacedFeature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeModificationContextImpl
implements BiomeModificationContext {
    private final DynamicRegistryManager registries;
    private final Biome biome;
    private final BiomeModificationContext.WeatherContext weather;
    private final BiomeModificationContext.EffectsContext effects;
    private final GenerationSettingsContextImpl generationSettings;
    private final SpawnSettingsContextImpl spawnSettings;

    public BiomeModificationContextImpl(DynamicRegistryManager registries, Biome biome) {
        this.registries = registries;
        this.biome = biome;
        this.weather = new WeatherContextImpl();
        this.effects = new EffectsContextImpl();
        this.generationSettings = new GenerationSettingsContextImpl();
        this.spawnSettings = new SpawnSettingsContextImpl();
    }

    @Override
    public BiomeModificationContext.WeatherContext getWeather() {
        return this.weather;
    }

    @Override
    public BiomeModificationContext.EffectsContext getEffects() {
        return this.effects;
    }

    @Override
    public BiomeModificationContext.GenerationSettingsContext getGenerationSettings() {
        return this.generationSettings;
    }

    @Override
    public BiomeModificationContext.SpawnSettingsContext getSpawnSettings() {
        return this.spawnSettings;
    }

    void freeze() {
        this.generationSettings.freeze();
        this.spawnSettings.freeze();
    }

    private static <T> RegistryEntry.Reference<T> getEntry(Registry<T> registry, RegistryKey<T> key) {
        RegistryEntry.Reference entry = registry.getEntry(key).orElse(null);
        if (entry == null) {
            throw new IllegalArgumentException("Couldn't find registry entry for " + String.valueOf(key));
        }
        return entry;
    }

    private class WeatherContextImpl
    implements BiomeModificationContext.WeatherContext {
        private WeatherContextImpl() {
        }

        @Override
        public void setPrecipitation(boolean hasPrecipitation) {
            BiomeModificationContextImpl.this.biome.weather = new Biome.Weather(hasPrecipitation, BiomeModificationContextImpl.this.biome.weather.temperature(), BiomeModificationContextImpl.this.biome.weather.temperatureModifier(), BiomeModificationContextImpl.this.biome.weather.downfall());
        }

        @Override
        public void setTemperature(float temperature) {
            BiomeModificationContextImpl.this.biome.weather = new Biome.Weather(BiomeModificationContextImpl.this.biome.weather.hasPrecipitation(), temperature, BiomeModificationContextImpl.this.biome.weather.temperatureModifier(), BiomeModificationContextImpl.this.biome.weather.downfall());
        }

        @Override
        public void setTemperatureModifier(Biome.TemperatureModifier temperatureModifier) {
            BiomeModificationContextImpl.this.biome.weather = new Biome.Weather(BiomeModificationContextImpl.this.biome.weather.hasPrecipitation(), BiomeModificationContextImpl.this.biome.weather.temperature(), Objects.requireNonNull(temperatureModifier), BiomeModificationContextImpl.this.biome.weather.downfall());
        }

        @Override
        public void setDownfall(float downfall) {
            BiomeModificationContextImpl.this.biome.weather = new Biome.Weather(BiomeModificationContextImpl.this.biome.weather.hasPrecipitation(), BiomeModificationContextImpl.this.biome.weather.temperature(), BiomeModificationContextImpl.this.biome.weather.temperatureModifier(), downfall);
        }
    }

    private class EffectsContextImpl
    implements BiomeModificationContext.EffectsContext {
        private final BiomeEffects effects;

        private EffectsContextImpl() {
            this.effects = BiomeModificationContextImpl.this.biome.getEffects();
        }

        @Override
        public void setFogColor(int color) {
            this.effects.fogColor = color;
        }

        @Override
        public void setWaterColor(int color) {
            this.effects.waterColor = color;
        }

        @Override
        public void setWaterFogColor(int color) {
            this.effects.waterFogColor = color;
        }

        @Override
        public void setSkyColor(int color) {
            this.effects.skyColor = color;
        }

        @Override
        public void setFoliageColor(Optional<Integer> color) {
            this.effects.foliageColor = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColor(Optional<Integer> color) {
            this.effects.grassColor = Objects.requireNonNull(color);
        }

        @Override
        public void setGrassColorModifier(@NotNull BiomeEffects.GrassColorModifier colorModifier) {
            this.effects.grassColorModifier = Objects.requireNonNull(colorModifier);
        }

        @Override
        public void setParticleConfig(Optional<BiomeParticleConfig> particleConfig) {
            this.effects.particleConfig = Objects.requireNonNull(particleConfig);
        }

        @Override
        public void setAmbientSound(Optional<RegistryEntry<SoundEvent>> sound) {
            this.effects.loopSound = Objects.requireNonNull(sound);
        }

        @Override
        public void setMoodSound(Optional<BiomeMoodSound> sound) {
            this.effects.moodSound = Objects.requireNonNull(sound);
        }

        @Override
        public void setAdditionsSound(Optional<BiomeAdditionsSound> sound) {
            this.effects.additionsSound = Objects.requireNonNull(sound);
        }

        @Override
        public void setMusic(Optional<MusicSound> sound) {
            this.effects.music = Objects.requireNonNull(sound);
        }
    }

    private class GenerationSettingsContextImpl
    implements BiomeModificationContext.GenerationSettingsContext {
        private final Registry<ConfiguredCarver<?>> carvers;
        private final Registry<PlacedFeature> features;
        private final GenerationSettings generationSettings;
        private boolean rebuildFlowerFeatures;

        GenerationSettingsContextImpl() {
            this.carvers = BiomeModificationContextImpl.this.registries.get(RegistryKeys.CONFIGURED_CARVER);
            this.features = BiomeModificationContextImpl.this.registries.get(RegistryKeys.PLACED_FEATURE);
            this.generationSettings = BiomeModificationContextImpl.this.biome.getGenerationSettings();
            this.unfreezeCarvers();
            this.unfreezeFeatures();
            this.rebuildFlowerFeatures = false;
        }

        private void unfreezeCarvers() {
            EnumMap carversByStep = new EnumMap(GenerationStep.Carver.class);
            carversByStep.putAll(this.generationSettings.carvers);
            this.generationSettings.carvers = carversByStep;
        }

        private void unfreezeFeatures() {
            this.generationSettings.features = new ArrayList(this.generationSettings.features);
        }

        public void freeze() {
            this.freezeCarvers();
            this.freezeFeatures();
            if (this.rebuildFlowerFeatures) {
                this.rebuildFlowerFeatures();
            }
        }

        private void freezeCarvers() {
            this.generationSettings.carvers = ImmutableMap.copyOf((Map)this.generationSettings.carvers);
        }

        private void freezeFeatures() {
            this.generationSettings.features = ImmutableList.copyOf((Collection)this.generationSettings.features);
            this.generationSettings.allowedFeatures = Suppliers.memoize(() -> this.generationSettings.features.stream().flatMap(RegistryEntryList::stream).map(RegistryEntry::value).collect(Collectors.toSet()));
        }

        private void rebuildFlowerFeatures() {
            this.generationSettings.flowerFeatures = Suppliers.memoize(() -> (List)this.generationSettings.features.stream().flatMap(RegistryEntryList::stream).map(RegistryEntry::value).flatMap(PlacedFeature::getDecoratedFeatures).filter(configuredFeature -> configuredFeature.feature() == Feature.FLOWER).collect(ImmutableList.toImmutableList()));
        }

        @Override
        public boolean removeFeature(GenerationStep.Feature step, RegistryKey<PlacedFeature> placedFeatureKey) {
            List featureSteps;
            PlacedFeature placedFeature = (PlacedFeature)BiomeModificationContextImpl.getEntry(this.features, placedFeatureKey).value();
            int stepIndex = step.ordinal();
            if (stepIndex >= (featureSteps = this.generationSettings.features).size()) {
                return false;
            }
            RegistryEntryList featuresInStep = (RegistryEntryList)featureSteps.get(stepIndex);
            ArrayList features = new ArrayList(featuresInStep.stream().toList());
            if (features.removeIf(feature -> feature.value() == placedFeature)) {
                featureSteps.set(stepIndex, RegistryEntryList.of(features));
                this.rebuildFlowerFeatures = true;
                return true;
            }
            return false;
        }

        @Override
        public void addFeature(GenerationStep.Feature step, RegistryKey<PlacedFeature> entry) {
            List featureSteps = this.generationSettings.features;
            int index = step.ordinal();
            while (index >= featureSteps.size()) {
                featureSteps.add(RegistryEntryList.of(Collections.emptyList()));
            }
            featureSteps.set(index, this.plus((RegistryEntryList)((RegistryEntryList)featureSteps.get(index)), (RegistryEntry)BiomeModificationContextImpl.getEntry(this.features, entry)));
            this.rebuildFlowerFeatures = true;
        }

        @Override
        public void addCarver(GenerationStep.Carver step, RegistryKey<ConfiguredCarver<?>> entry) {
            this.generationSettings.carvers.put(step, this.plus((RegistryEntryList)((RegistryEntryList)this.generationSettings.carvers.get(step)), (RegistryEntry)BiomeModificationContextImpl.getEntry(this.carvers, entry)));
        }

        @Override
        public boolean removeCarver(GenerationStep.Carver step, RegistryKey<ConfiguredCarver<?>> configuredCarverKey) {
            ConfiguredCarver carver = (ConfiguredCarver)BiomeModificationContextImpl.getEntry(this.carvers, configuredCarverKey).value();
            RegistryEntryList carvers = (RegistryEntryList)this.generationSettings.carvers.get(step);
            if (carvers == null) {
                return false;
            }
            ArrayList genCarvers = new ArrayList(carvers.stream().toList());
            if (genCarvers.removeIf(entry -> entry.value() == carver)) {
                this.generationSettings.carvers.put(step, RegistryEntryList.of(genCarvers));
                return true;
            }
            return false;
        }

        private <T> RegistryEntryList<T> plus(@Nullable RegistryEntryList<T> values, RegistryEntry<T> entry) {
            if (values == null) {
                return RegistryEntryList.of((RegistryEntry[])new RegistryEntry[]{entry});
            }
            ArrayList list = new ArrayList(values.stream().toList());
            list.add(entry);
            return RegistryEntryList.of(list);
        }
    }

    private class SpawnSettingsContextImpl
    implements BiomeModificationContext.SpawnSettingsContext {
        private final SpawnSettings spawnSettings;
        private final EnumMap<SpawnGroup, List<SpawnSettings.SpawnEntry>> fabricSpawners;

        SpawnSettingsContextImpl() {
            this.spawnSettings = BiomeModificationContextImpl.this.biome.getSpawnSettings();
            this.fabricSpawners = new EnumMap(SpawnGroup.class);
            this.unfreezeSpawners();
            this.unfreezeSpawnCost();
        }

        private void unfreezeSpawners() {
            this.fabricSpawners.clear();
            for (SpawnGroup spawnGroup : SpawnGroup.values()) {
                Pool entries = (Pool)this.spawnSettings.spawners.get(spawnGroup);
                if (entries != null) {
                    this.fabricSpawners.put(spawnGroup, new ArrayList(entries.getEntries()));
                    continue;
                }
                this.fabricSpawners.put(spawnGroup, new ArrayList());
            }
        }

        private void unfreezeSpawnCost() {
            this.spawnSettings.spawnCosts = new HashMap(this.spawnSettings.spawnCosts);
        }

        public void freeze() {
            this.freezeSpawners();
            this.freezeSpawnCosts();
        }

        private void freezeSpawners() {
            HashMap<SpawnGroup, Pool> spawners = new HashMap<SpawnGroup, Pool>(this.spawnSettings.spawners);
            for (Map.Entry<SpawnGroup, List<SpawnSettings.SpawnEntry>> entry : this.fabricSpawners.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    spawners.put(entry.getKey(), Pool.empty());
                    continue;
                }
                spawners.put(entry.getKey(), Pool.of(entry.getValue()));
            }
            this.spawnSettings.spawners = ImmutableMap.copyOf(spawners);
        }

        private void freezeSpawnCosts() {
            this.spawnSettings.spawnCosts = ImmutableMap.copyOf((Map)this.spawnSettings.spawnCosts);
        }

        @Override
        public void setCreatureSpawnProbability(float probability) {
            this.spawnSettings.creatureSpawnProbability = probability;
        }

        @Override
        public void addSpawn(SpawnGroup spawnGroup, SpawnSettings.SpawnEntry spawnEntry) {
            Objects.requireNonNull(spawnGroup);
            Objects.requireNonNull(spawnEntry);
            this.fabricSpawners.get(spawnGroup).add(spawnEntry);
        }

        @Override
        public boolean removeSpawns(BiPredicate<SpawnGroup, SpawnSettings.SpawnEntry> predicate) {
            boolean anyRemoved = false;
            for (SpawnGroup group : SpawnGroup.values()) {
                if (!this.fabricSpawners.get(group).removeIf(entry -> predicate.test(group, (SpawnSettings.SpawnEntry)entry))) continue;
                anyRemoved = true;
            }
            return anyRemoved;
        }

        @Override
        public void setSpawnCost(EntityType<?> entityType, double mass, double gravityLimit) {
            Objects.requireNonNull(entityType);
            this.spawnSettings.spawnCosts.put(entityType, new SpawnSettings.SpawnDensity(gravityLimit, mass));
        }

        @Override
        public void clearSpawnCost(EntityType<?> entityType) {
            this.spawnSettings.spawnCosts.remove(entityType);
        }
    }
}

