/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.fabricmc.fabric.impl.biome.MultiNoiseSamplerHooks;
import net.fabricmc.fabric.impl.biome.WeightedPicker;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.util.math.noise.PerlinNoiseSampler;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeKeys;
import net.minecraft.world.biome.source.util.MultiNoiseUtil;
import org.jetbrains.annotations.Nullable;

public final class TheEndBiomeData {
    public static final ThreadLocal<RegistryEntryLookup<Biome>> biomeRegistry = new ThreadLocal();
    public static final Set<RegistryKey<Biome>> ADDED_BIOMES = new HashSet<RegistryKey<Biome>>();
    private static final Map<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>> END_BIOMES_MAP = new IdentityHashMap<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>>();
    private static final Map<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>> END_MIDLANDS_MAP = new IdentityHashMap<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>>();
    private static final Map<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>> END_BARRENS_MAP = new IdentityHashMap<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>>();

    private TheEndBiomeData() {
    }

    public static void addEndBiomeReplacement(RegistryKey<Biome> replaced, RegistryKey<Biome> variant, double weight) {
        Preconditions.checkNotNull(replaced, (Object)"replaced entry is null");
        Preconditions.checkNotNull(variant, (Object)"variant entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BIOMES_MAP.computeIfAbsent(replaced, key -> new WeightedPicker()).add(variant, weight);
        ADDED_BIOMES.add(variant);
    }

    public static void addEndMidlandsReplacement(RegistryKey<Biome> highlands, RegistryKey<Biome> midlands, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(midlands, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_MIDLANDS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(midlands, weight);
        ADDED_BIOMES.add(midlands);
    }

    public static void addEndBarrensReplacement(RegistryKey<Biome> highlands, RegistryKey<Biome> barrens, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands entry is null");
        Preconditions.checkNotNull(barrens, (Object)"midlands entry is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BARRENS_MAP.computeIfAbsent(highlands, key -> new WeightedPicker()).add(barrens, weight);
        ADDED_BIOMES.add(barrens);
    }

    public static Overrides createOverrides(RegistryEntryLookup<Biome> biomes) {
        return new Overrides(biomes);
    }

    static {
        END_BIOMES_MAP.computeIfAbsent((RegistryKey<Biome>)BiomeKeys.THE_END, key -> new WeightedPicker()).add(BiomeKeys.THE_END, 1.0);
        END_BIOMES_MAP.computeIfAbsent((RegistryKey<Biome>)BiomeKeys.END_HIGHLANDS, key -> new WeightedPicker()).add(BiomeKeys.END_HIGHLANDS, 1.0);
        END_BIOMES_MAP.computeIfAbsent((RegistryKey<Biome>)BiomeKeys.SMALL_END_ISLANDS, key -> new WeightedPicker()).add(BiomeKeys.SMALL_END_ISLANDS, 1.0);
        END_MIDLANDS_MAP.computeIfAbsent((RegistryKey<Biome>)BiomeKeys.END_HIGHLANDS, key -> new WeightedPicker()).add(BiomeKeys.END_MIDLANDS, 1.0);
        END_BARRENS_MAP.computeIfAbsent((RegistryKey<Biome>)BiomeKeys.END_HIGHLANDS, key -> new WeightedPicker()).add(BiomeKeys.END_BARRENS, 1.0);
    }

    public static class Overrides {
        public final Set<RegistryEntry<Biome>> customBiomes;
        private final RegistryEntry<Biome> endMidlands;
        private final RegistryEntry<Biome> endBarrens;
        private final RegistryEntry<Biome> endHighlands;
        @Nullable
        private final Map<RegistryEntry<Biome>, WeightedPicker<RegistryEntry<Biome>>> endBiomesMap;
        @Nullable
        private final Map<RegistryEntry<Biome>, WeightedPicker<RegistryEntry<Biome>>> endMidlandsMap;
        @Nullable
        private final Map<RegistryEntry<Biome>, WeightedPicker<RegistryEntry<Biome>>> endBarrensMap;
        private final Map<MultiNoiseUtil.MultiNoiseSampler, PerlinNoiseSampler> samplers = new WeakHashMap<MultiNoiseUtil.MultiNoiseSampler, PerlinNoiseSampler>();

        public Overrides(RegistryEntryLookup<Biome> biomeRegistry) {
            this.customBiomes = ADDED_BIOMES.stream().map(arg_0 -> biomeRegistry.getOrThrow(arg_0)).collect(Collectors.toSet());
            this.endMidlands = biomeRegistry.getOrThrow(BiomeKeys.END_MIDLANDS);
            this.endBarrens = biomeRegistry.getOrThrow(BiomeKeys.END_BARRENS);
            this.endHighlands = biomeRegistry.getOrThrow(BiomeKeys.END_HIGHLANDS);
            this.endBiomesMap = this.resolveOverrides(biomeRegistry, END_BIOMES_MAP, (RegistryKey<Biome>)BiomeKeys.THE_END);
            this.endMidlandsMap = this.resolveOverrides(biomeRegistry, END_MIDLANDS_MAP, (RegistryKey<Biome>)BiomeKeys.END_MIDLANDS);
            this.endBarrensMap = this.resolveOverrides(biomeRegistry, END_BARRENS_MAP, (RegistryKey<Biome>)BiomeKeys.END_BARRENS);
        }

        @Nullable
        private Map<RegistryEntry<Biome>, WeightedPicker<RegistryEntry<Biome>>> resolveOverrides(RegistryEntryLookup<Biome> biomeRegistry, Map<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>> overrides, RegistryKey<Biome> vanillaKey) {
            Object2ObjectOpenCustomHashMap result = new Object2ObjectOpenCustomHashMap(overrides.size(), (Hash.Strategy)RegistryKeyHashStrategy.INSTANCE);
            for (Map.Entry<RegistryKey<Biome>, WeightedPicker<RegistryKey<Biome>>> entry : overrides.entrySet()) {
                WeightedPicker<RegistryKey<Biome>> picker = entry.getValue();
                int count = picker.getEntryCount();
                if (count == 0 || count == 1 && entry.getKey() == vanillaKey) continue;
                result.put(biomeRegistry.getOrThrow(entry.getKey()), picker.map(arg_0 -> biomeRegistry.getOrThrow(arg_0)));
            }
            return result.isEmpty() ? null : result;
        }

        public RegistryEntry<Biome> pick(int x, int y, int z, MultiNoiseUtil.MultiNoiseSampler noise, RegistryEntry<Biome> vanillaBiome) {
            block5: {
                boolean isMidlands;
                block4: {
                    isMidlands = vanillaBiome.matches(arg_0 -> this.endMidlands.matchesKey(arg_0));
                    if (isMidlands) break block4;
                    if (!vanillaBiome.matches(arg_0 -> this.endBarrens.matchesKey(arg_0))) break block5;
                }
                RegistryEntry<Biome> highlandsReplacement = this.pick(this.endHighlands, this.endHighlands, this.endBiomesMap, x, z, noise);
                Map<RegistryEntry<Biome>, WeightedPicker<RegistryEntry<Biome>>> map = isMidlands ? this.endMidlandsMap : this.endBarrensMap;
                return this.pick(highlandsReplacement, vanillaBiome, map, x, z, noise);
            }
            assert (END_BIOMES_MAP.containsKey(vanillaBiome.getKey().orElseThrow()));
            return this.pick(vanillaBiome, vanillaBiome, this.endBiomesMap, x, z, noise);
        }

        private <T extends RegistryEntry<Biome>> T pick(T key, T defaultValue, Map<T, WeightedPicker<T>> pickers, int x, int z, MultiNoiseUtil.MultiNoiseSampler noise) {
            WeightedPicker<T> picker;
            block6: {
                block5: {
                    if (pickers == null) {
                        return defaultValue;
                    }
                    picker = pickers.get(key);
                    if (picker == null) {
                        return defaultValue;
                    }
                    int count = picker.getEntryCount();
                    if (count == 0) break block5;
                    if (count != 1) break block6;
                    if (!key.matches(arg_0 -> this.endHighlands.matchesKey(arg_0))) break block6;
                }
                return defaultValue;
            }
            return (T)((RegistryEntry)picker.pickFromNoise(((MultiNoiseSamplerHooks)noise).fabric_getEndBiomesSampler(), (double)x / 64.0, 0.0, (double)z / 64.0));
        }
    }

    static enum RegistryKeyHashStrategy implements Hash.Strategy<RegistryEntry<?>>
    {
        INSTANCE;


        public boolean equals(RegistryEntry<?> a, RegistryEntry<?> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.getType() != b.getType()) {
                return false;
            }
            return (Boolean)a.getKeyOrValue().map(key -> b.getKey().get() == key, b.value()::equals);
        }

        public int hashCode(RegistryEntry<?> a) {
            if (a == null) {
                return 0;
            }
            return (Integer)a.getKeyOrValue().map(System::identityHashCode, Object::hashCode);
        }
    }
}

