/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.registry.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.source.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.biome.source.util.MultiNoiseUtil;

public final class NetherBiomeData {
    private static final Set<RegistryKey<Biome>> NETHER_BIOMES = new HashSet<RegistryKey<Biome>>();
    private static final Map<RegistryKey<Biome>, MultiNoiseUtil.NoiseHypercube> NETHER_BIOME_NOISE_POINTS = new HashMap<RegistryKey<Biome>, MultiNoiseUtil.NoiseHypercube>();

    private NetherBiomeData() {
    }

    public static void addNetherBiome(RegistryKey<Biome> biome, MultiNoiseUtil.NoiseHypercube spawnNoisePoint) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((spawnNoisePoint != null ? 1 : 0) != 0, (Object)"MultiNoiseUtil.NoiseValuePoint is null");
        NETHER_BIOME_NOISE_POINTS.put(biome, spawnNoisePoint);
        NetherBiomeData.clearBiomeSourceCache();
    }

    public static boolean canGenerateInNether(RegistryKey<Biome> biome) {
        return MultiNoiseBiomeSourceParameterList.Preset.NETHER.biomeStream().anyMatch(input -> input.equals(biome));
    }

    private static void clearBiomeSourceCache() {
        NETHER_BIOMES.clear();
    }

    public static <T> MultiNoiseUtil.Entries<T> withModdedBiomeEntries(MultiNoiseUtil.Entries<T> entries, Function<RegistryKey<Biome>, T> biomes) {
        if (NETHER_BIOME_NOISE_POINTS.isEmpty()) {
            return entries;
        }
        ArrayList<Pair> entryList = new ArrayList<Pair>(entries.getEntries());
        for (Map.Entry<RegistryKey<Biome>, MultiNoiseUtil.NoiseHypercube> entry : NETHER_BIOME_NOISE_POINTS.entrySet()) {
            entryList.add(Pair.of((Object)entry.getValue(), biomes.apply(entry.getKey())));
        }
        return new MultiNoiseUtil.Entries(Collections.unmodifiableList(entryList));
    }
}

