/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnGroup;
import net.minecraft.registry.Registries;
import net.minecraft.registry.RegistryKey;
import net.minecraft.util.Identifier;
import net.minecraft.world.biome.SpawnSettings;
import net.minecraft.world.gen.GenerationStep;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.PlacedFeature;

public final class BiomeModifications {
    private BiomeModifications() {
    }

    public static void addFeature(Predicate<BiomeSelectionContext> biomeSelector, GenerationStep.Feature step, RegistryKey<PlacedFeature> placedFeatureRegistryKey) {
        BiomeModifications.create(placedFeatureRegistryKey.getValue()).add(ModificationPhase.ADDITIONS, biomeSelector, context -> context.getGenerationSettings().addFeature(step, placedFeatureRegistryKey));
    }

    public static void addCarver(Predicate<BiomeSelectionContext> biomeSelector, GenerationStep.Carver step, RegistryKey<ConfiguredCarver<?>> configuredCarverKey) {
        BiomeModifications.create(configuredCarverKey.getValue()).add(ModificationPhase.ADDITIONS, biomeSelector, context -> context.getGenerationSettings().addCarver(step, configuredCarverKey));
    }

    public static void addSpawn(Predicate<BiomeSelectionContext> biomeSelector, SpawnGroup spawnGroup, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        Preconditions.checkArgument((entityType.getSpawnGroup() != SpawnGroup.MISC ? 1 : 0) != 0, (Object)"Cannot add spawns for entities with spawnGroup=MISC since they'd be replaced by pigs.");
        Identifier id = Registries.ENTITY_TYPE.getId(entityType);
        Preconditions.checkState((boolean)Registries.ENTITY_TYPE.getKey(entityType).isPresent(), (String)"Unregistered entity type: %s", entityType);
        BiomeModifications.create(id).add(ModificationPhase.ADDITIONS, biomeSelector, context -> context.getSpawnSettings().addSpawn(spawnGroup, new SpawnSettings.SpawnEntry(entityType, weight, minGroupSize, maxGroupSize)));
    }

    public static BiomeModification create(Identifier id) {
        return new BiomeModification(id);
    }
}

