/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.transfer.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.block.BlockState;
import net.minecraft.block.ComposterBlock;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.Items;
import net.minecraft.sound.SoundCategory;
import net.minecraft.sound.SoundEvents;
import net.minecraft.state.property.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class ComposterWrapper
extends SnapshotParticipant<Float> {
    private static final Map<WorldLocation, ComposterWrapper> COMPOSTERS = new MapMaker().concurrencyLevel(1).weakValues().makeMap();
    private static final float DO_NOTHING = 0.0f;
    private static final float EXTRACT_BONEMEAL = -1.0f;
    private final WorldLocation location;
    private Float increaseProbability = Float.valueOf(0.0f);
    private final TopStorage upStorage = new TopStorage();
    private final BottomStorage downStorage = new BottomStorage();

    @Nullable
    public static Storage<ItemVariant> get(World world, BlockPos pos, @Nullable Direction direction) {
        if (direction != null && direction.getAxis().isVertical()) {
            WorldLocation location = new WorldLocation(world, pos.toImmutable());
            ComposterWrapper composterWrapper = COMPOSTERS.computeIfAbsent(location, ComposterWrapper::new);
            return direction == Direction.UP ? composterWrapper.upStorage : composterWrapper.downStorage;
        }
        return null;
    }

    private ComposterWrapper(WorldLocation location) {
        this.location = location;
    }

    @Override
    protected Float createSnapshot() {
        return this.increaseProbability;
    }

    @Override
    protected void readSnapshot(Float snapshot) {
        this.increaseProbability = snapshot;
    }

    @Override
    protected void onFinalCommit() {
        if (this.increaseProbability.floatValue() == -1.0f) {
            this.location.setBlockState((BlockState)this.location.getBlockState().with((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(0)));
            this.location.world.playSound(null, this.location.pos, SoundEvents.BLOCK_COMPOSTER_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (this.increaseProbability.floatValue() > 0.0f) {
            boolean increaseSuccessful;
            BlockState state = this.location.getBlockState();
            boolean bl = increaseSuccessful = (Integer)state.get((Property)ComposterBlock.LEVEL) == 0 || this.location.world.getRandom().nextDouble() < (double)this.increaseProbability.floatValue();
            if (increaseSuccessful) {
                int newLevel = (Integer)state.get((Property)ComposterBlock.LEVEL) + 1;
                BlockState newState = (BlockState)state.with((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(newLevel));
                this.location.setBlockState(newState);
                if (newLevel == 7) {
                    this.location.world.scheduleBlockTick(this.location.pos, state.getBlock(), 20);
                }
            }
            this.location.world.syncWorldEvent(1500, this.location.pos, increaseSuccessful ? 1 : 0);
        }
        this.increaseProbability = Float.valueOf(0.0f);
    }

    private record WorldLocation(World world, BlockPos pos) {
        private BlockState getBlockState() {
            return this.world.getBlockState(this.pos);
        }

        private void setBlockState(BlockState state) {
            this.world.setBlockState(this.pos, state);
        }

        @Override
        public String toString() {
            return DebugMessages.forGlobalPos(this.world, this.pos);
        }
    }

    private class TopStorage
    implements InsertionOnlyStorage<ItemVariant> {
        private TopStorage() {
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, maxAmount);
            if (maxAmount < 1L) {
                return 0L;
            }
            if (ComposterWrapper.this.increaseProbability.floatValue() != 0.0f) {
                return 0L;
            }
            if ((Integer)ComposterWrapper.this.location.getBlockState().get((Property)ComposterBlock.LEVEL) >= 7) {
                return 0L;
            }
            float insertedIncreaseProbability = ComposterBlock.ITEM_TO_LEVEL_INCREASE_CHANCE.getFloat((Object)resource.getItem());
            if (insertedIncreaseProbability <= 0.0f) {
                return 0L;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            ComposterWrapper.this.increaseProbability = Float.valueOf(insertedIncreaseProbability);
            return 1L;
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/top]";
        }
    }

    private class BottomStorage
    implements ExtractionOnlyStorage<ItemVariant>,
    SingleSlotStorage<ItemVariant> {
        private static final ItemVariant BONE_MEAL = ItemVariant.of((ItemConvertible)Items.BONE_MEAL);

        private BottomStorage() {
        }

        private boolean hasBoneMeal() {
            return ComposterWrapper.this.increaseProbability.floatValue() == 0.0f && (Integer)ComposterWrapper.this.location.getBlockState().get((Property)ComposterBlock.LEVEL) == 8;
        }

        @Override
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, maxAmount);
            if (maxAmount < 1L) {
                return 0L;
            }
            if (!BONE_MEAL.equals(resource)) {
                return 0L;
            }
            if (!this.hasBoneMeal()) {
                return 0L;
            }
            ComposterWrapper.this.updateSnapshots(transaction);
            ComposterWrapper.this.increaseProbability = Float.valueOf(-1.0f);
            return 1L;
        }

        @Override
        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        @Override
        public ItemVariant getResource() {
            return BONE_MEAL;
        }

        @Override
        public long getAmount() {
            return this.hasBoneMeal() ? 1L : 0L;
        }

        @Override
        public long getCapacity() {
            return 1L;
        }

        public String toString() {
            return "ComposterWrapper[" + String.valueOf(ComposterWrapper.this.location) + "/bottom]";
        }
    }
}

