/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.storage;

import java.util.Objects;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.PacketByteBuf;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface TransferVariant<O> {
    public boolean isBlank();

    public O getObject();

    @Nullable
    public NbtCompound getNbt();

    default public boolean hasNbt() {
        return this.getNbt() != null;
    }

    default public boolean nbtMatches(@Nullable NbtCompound other) {
        return Objects.equals(this.getNbt(), other);
    }

    default public boolean isOf(O object) {
        return this.getObject() == object;
    }

    @Nullable
    default public NbtCompound copyNbt() {
        NbtCompound nbt = this.getNbt();
        return nbt == null ? null : nbt.copy();
    }

    default public NbtCompound copyOrCreateNbt() {
        NbtCompound nbt = this.getNbt();
        return nbt == null ? new NbtCompound() : nbt.copy();
    }

    public NbtCompound toNbt();

    public void toPacket(PacketByteBuf var1);
}

