/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.item;

import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.impl.transfer.item.ItemVariantImpl;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.network.PacketByteBuf;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface ItemVariant
extends TransferVariant<Item> {
    public static ItemVariant blank() {
        return ItemVariant.of((ItemConvertible)Items.AIR);
    }

    public static ItemVariant of(ItemStack stack) {
        return ItemVariant.of((ItemConvertible)stack.getItem(), stack.getNbt());
    }

    public static ItemVariant of(ItemConvertible item) {
        return ItemVariant.of(item, null);
    }

    public static ItemVariant of(ItemConvertible item, @Nullable NbtCompound tag) {
        return ItemVariantImpl.of(item.asItem(), tag);
    }

    default public boolean matches(ItemStack stack) {
        return this.isOf(stack.getItem()) && this.nbtMatches(stack.getNbt());
    }

    default public Item getItem() {
        return (Item)this.getObject();
    }

    default public ItemStack toStack() {
        return this.toStack(1);
    }

    default public ItemStack toStack(int count) {
        if (this.isBlank()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemConvertible)this.getItem(), count);
        stack.setNbt(this.copyNbt());
        return stack;
    }

    public static ItemVariant fromNbt(NbtCompound nbt) {
        return ItemVariantImpl.fromNbt(nbt);
    }

    public static ItemVariant fromPacket(PacketByteBuf buf) {
        return ItemVariantImpl.fromPacket(buf);
    }
}

