/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.transfer.v1.item;

import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.impl.transfer.item.ComposterWrapper;
import net.fabricmc.fabric.mixin.transfer.DoubleInventoryAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.InventoryProvider;
import net.minecraft.block.entity.ChestBlockEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.SidedInventory;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.World;
import net.minecraft.world.WorldAccess;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class ItemStorage {
    public static final BlockApiLookup<Storage<ItemVariant>, @Nullable Direction> SIDED = BlockApiLookup.get((Identifier)new Identifier("fabric:sided_item_storage"), Storage.asClass(), Direction.class);

    private ItemStorage() {
    }

    static {
        SIDED.registerForBlocks((world, pos, state, blockEntity, direction) -> ComposterWrapper.get(world, pos, direction), new Block[]{Blocks.COMPOSTER});
        SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            if (blockEntity instanceof SidedStorageBlockEntity) {
                SidedStorageBlockEntity sidedStorageBlockEntity = (SidedStorageBlockEntity)blockEntity;
                return sidedStorageBlockEntity.getItemStorage((Direction)direction);
            }
            return null;
        });
        SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            SidedInventory second;
            InventoryProvider provider;
            SidedInventory first;
            Inventory inventoryToWrap = null;
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof InventoryProvider && (first = (provider = (InventoryProvider)patt0$temp).getInventory(state, (WorldAccess)world, pos)) == (second = provider.getInventory(state, (WorldAccess)world, pos)) && first != null) {
                return InventoryStorage.of((Inventory)first, direction);
            }
            if (blockEntity instanceof Inventory) {
                Block patt1$temp;
                Inventory inventory = (Inventory)blockEntity;
                if (blockEntity instanceof ChestBlockEntity && (patt1$temp = state.getBlock()) instanceof ChestBlock) {
                    ChestBlock chestBlock = (ChestBlock)patt1$temp;
                    inventoryToWrap = ChestBlock.getInventory((ChestBlock)chestBlock, (BlockState)state, (World)world, (BlockPos)pos, (boolean)true);
                    if (inventoryToWrap instanceof DoubleInventoryAccessor) {
                        DoubleInventoryAccessor accessor = (DoubleInventoryAccessor)inventoryToWrap;
                        InventoryStorage first2 = InventoryStorage.of(accessor.fabric_getFirst(), direction);
                        InventoryStorage second2 = InventoryStorage.of(accessor.fabric_getSecond(), direction);
                        return new CombinedSlottedStorage(List.of(first2, second2));
                    }
                } else {
                    inventoryToWrap = inventory;
                }
            }
            return inventoryToWrap != null ? InventoryStorage.of(inventoryToWrap, direction) : null;
        });
    }
}

