/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.entity.event;

import com.mojang.datafixers.util.Either;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerEntity.class})
abstract class PlayerEntityMixin {
    PlayerEntityMixin() {
    }

    @Inject(method={"trySleep"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTrySleep(BlockPos pos, CallbackInfoReturnable<Either<PlayerEntity.SleepFailureReason, Unit>> info) {
        PlayerEntity.SleepFailureReason failureReason = ((EntitySleepEvents.AllowSleeping)EntitySleepEvents.ALLOW_SLEEPING.invoker()).allowSleep((PlayerEntity)this, pos);
        if (failureReason != null) {
            info.setReturnValue((Object)Either.left((Object)failureReason));
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isDay()Z"))
    private boolean redirectDaySleepCheck(World world) {
        boolean day = world.isDay();
        if (((LivingEntity)this).getSleepingPosition().isPresent()) {
            BlockPos pos = (BlockPos)((LivingEntity)this).getSleepingPosition().get();
            ActionResult result = ((EntitySleepEvents.AllowSleepTime)EntitySleepEvents.ALLOW_SLEEP_TIME.invoker()).allowSleepTime((PlayerEntity)this, pos, !day);
            if (result != ActionResult.PASS) {
                return !result.isAccepted();
            }
        }
        return day;
    }

    @Inject(method={"canResetTimeBySleeping"}, at={@At(value="RETURN")}, cancellable=true)
    private void onIsSleepingLongEnough(CallbackInfoReturnable<Boolean> info) {
        if (info.getReturnValueZ()) {
            info.setReturnValue((Object)((EntitySleepEvents.AllowResettingTime)EntitySleepEvents.ALLOW_RESETTING_TIME.invoker()).allowResettingTime((PlayerEntity)this));
        }
    }
}

