/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.entity.event;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.damage.DamageSource;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.state.property.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BlockView;
import net.minecraft.world.CollisionView;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @Shadow
    public abstract boolean method_29504();

    @Shadow
    public abstract Optional<BlockPos> method_18398();

    @WrapOperation(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onKilledOther(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)Z")})
    private boolean onEntityKilledOther(Entity entity, ServerWorld serverWorld, @Nullable LivingEntity attacker, Operation<Boolean> original) {
        boolean result = (Boolean)original.call(new Object[]{entity, serverWorld, attacker});
        ((ServerEntityCombatEvents.AfterKilledOtherEntity)ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.invoker()).afterKilledOtherEntity(serverWorld, entity, attacker);
        return result;
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="net/minecraft/world/World.sendEntityStatus(Lnet/minecraft/entity/Entity;B)V")})
    private void notifyDeath(DamageSource source, CallbackInfo ci) {
        ((ServerLivingEntityEvents.AfterDeath)ServerLivingEntityEvents.AFTER_DEATH.invoker()).afterDeath((LivingEntity)this, source);
    }

    @Redirect(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isDead()Z", ordinal=1))
    boolean beforeEntityKilled(LivingEntity livingEntity, DamageSource source, float amount) {
        return this.method_29504() && ((ServerLivingEntityEvents.AllowDeath)ServerLivingEntityEvents.ALLOW_DEATH.invoker()).allowDeath(livingEntity, source, amount);
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="net/minecraft/entity/LivingEntity.isSleeping()Z")}, cancellable=true)
    private void beforeDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!((ServerLivingEntityEvents.AllowDamage)ServerLivingEntityEvents.ALLOW_DAMAGE.invoker()).allowDamage((LivingEntity)this, source, amount)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"sleep"}, at={@At(value="RETURN")})
    private void onSleep(BlockPos pos, CallbackInfo info) {
        ((EntitySleepEvents.StartSleeping)EntitySleepEvents.START_SLEEPING.invoker()).onStartSleeping((LivingEntity)this, pos);
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    private void onWakeUp(CallbackInfo info) {
        BlockPos sleepingPos = this.method_18398().orElse(null);
        if (sleepingPos != null) {
            ((EntitySleepEvents.StopSleeping)EntitySleepEvents.STOP_SLEEPING.invoker()).onStopSleeping((LivingEntity)this, sleepingPos);
        }
    }

    @Inject(method={"method_18405"}, at={@At(value="RETURN")}, cancellable=true)
    @Dynamic(value="method_18405: Synthetic lambda body for Optional.map in isSleepingInBed")
    private void onIsSleepingInBed(BlockPos sleepingPos, CallbackInfoReturnable<Boolean> info) {
        BlockState bedState = ((LivingEntity)this).getWorld().getBlockState(sleepingPos);
        ActionResult result = ((EntitySleepEvents.AllowBed)EntitySleepEvents.ALLOW_BED.invoker()).allowBed((LivingEntity)this, sleepingPos, bedState, info.getReturnValueZ());
        if (result != ActionResult.PASS) {
            info.setReturnValue((Object)result.isAccepted());
        }
    }

    @WrapOperation(method={"getSleepingDirection"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BedBlock;getDirection(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/Direction;")})
    private Direction onGetSleepingDirection(BlockView world, BlockPos sleepingPos, Operation<Direction> operation) {
        Direction sleepingDirection = (Direction)operation.call(new Object[]{world, sleepingPos});
        return ((EntitySleepEvents.ModifySleepingDirection)EntitySleepEvents.MODIFY_SLEEPING_DIRECTION.invoker()).modifySleepDirection((LivingEntity)this, sleepingPos, sleepingDirection);
    }

    @ModifyVariable(method={"method_18404", "sleep"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    @Dynamic(value="method_18404: Synthetic lambda body for Optional.ifPresent in wakeUp")
    private BlockState modifyBedForOccupiedState(BlockState state, BlockPos sleepingPos) {
        ActionResult result = ((EntitySleepEvents.AllowBed)EntitySleepEvents.ALLOW_BED.invoker()).allowBed((LivingEntity)this, sleepingPos, state, state.getBlock() instanceof BedBlock);
        return result.isAccepted() ? Blocks.RED_BED.getDefaultState() : state;
    }

    @Redirect(method={"method_18404", "sleep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"))
    @Dynamic(value="method_18404: Synthetic lambda body for Optional.ifPresent in wakeUp")
    private boolean setOccupiedState(World world, BlockPos pos, BlockState state, int flags) {
        BlockState originalState = world.getBlockState(pos);
        boolean occupied = (Boolean)state.get((Property)BedBlock.OCCUPIED);
        if (((EntitySleepEvents.SetBedOccupationState)EntitySleepEvents.SET_BED_OCCUPATION_STATE.invoker()).setBedOccupationState((LivingEntity)this, pos, originalState, occupied)) {
            return true;
        }
        if (originalState.contains((Property)BedBlock.OCCUPIED)) {
            return world.setBlockState(pos, (BlockState)originalState.with((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(occupied)), flags);
        }
        return false;
    }

    @Redirect(method={"method_18404"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BedBlock;findWakeUpPosition(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/CollisionView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;F)Ljava/util/Optional;"))
    @Dynamic(value="method_18404: Synthetic lambda body for Optional.ifPresent in wakeUp")
    private Optional<Vec3d> modifyWakeUpPosition(EntityType<?> type, CollisionView world, BlockPos pos, Direction direction, float yaw) {
        Optional original = Optional.empty();
        BlockState bedState = world.getBlockState(pos);
        if (bedState.getBlock() instanceof BedBlock) {
            original = BedBlock.findWakeUpPosition(type, (CollisionView)world, (BlockPos)pos, (Direction)direction, (float)yaw);
        }
        Vec3d newPos = ((EntitySleepEvents.ModifyWakeUpPosition)EntitySleepEvents.MODIFY_WAKE_UP_POSITION.invoker()).modifyWakeUpPosition((LivingEntity)this, pos, bedState, original.orElse(null));
        return Optional.ofNullable(newPos);
    }
}

