/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.mininglevel.v1;

import net.fabricmc.fabric.impl.mininglevel.MiningLevelManagerImpl;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.tag.BlockTags;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.util.Identifier;

public final class MiningLevelManager {
    private MiningLevelManager() {
    }

    public static int getRequiredMiningLevel(BlockState state) {
        return MiningLevelManagerImpl.getRequiredMiningLevel(state);
    }

    public static TagKey<Block> getBlockTag(int miningLevel) {
        if (miningLevel <= 0) {
            throw new IllegalArgumentException("Mining level tags only exist for mining levels > 0, received: " + miningLevel);
        }
        return switch (miningLevel) {
            case 1 -> BlockTags.NEEDS_STONE_TOOL;
            case 2 -> BlockTags.NEEDS_IRON_TOOL;
            case 3 -> BlockTags.NEEDS_DIAMOND_TOOL;
            default -> TagKey.of((RegistryKey)RegistryKeys.BLOCK, (Identifier)new Identifier("fabric", "needs_tool_level_" + miningLevel));
        };
    }
}

