/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import net.fabricmc.fabric.impl.registry.sync.DynamicRegistriesImpl;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.tag.TagManagerLoader;
import net.minecraft.util.Identifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagManagerLoader.class})
abstract class TagManagerLoaderMixin {
    TagManagerLoaderMixin() {
    }

    @Inject(method={"getPath"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onGetPath(RegistryKey<? extends Registry<?>> registry, CallbackInfoReturnable<String> info) {
        if (!DynamicRegistriesImpl.DYNAMIC_REGISTRY_KEYS.contains(registry)) {
            return;
        }
        Identifier id = registry.getValue();
        if (!id.getNamespace().equals("minecraft")) {
            info.setReturnValue((Object)("tags/" + id.getNamespace() + "/" + id.getPath()));
        }
    }
}

