/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import com.mojang.datafixers.util.Pair;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.impl.registry.sync.DynamicRegistriesImpl;
import net.fabricmc.fabric.impl.registry.sync.DynamicRegistryViewImpl;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.registry.MutableRegistry;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryLoader;
import net.minecraft.registry.RegistryOps;
import net.minecraft.resource.ResourceManager;
import net.minecraft.util.Identifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RegistryLoader.class})
public class RegistryLoaderMixin {
    @Inject(method={"load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/DynamicRegistryManager;Ljava/util/List;)Lnet/minecraft/registry/DynamicRegistryManager$Immutable;"}, at={@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void beforeLoad(ResourceManager resourceManager, DynamicRegistryManager baseRegistryManager, List<RegistryLoader.Entry<?>> entries, CallbackInfoReturnable<DynamicRegistryManager.Immutable> cir, Map a, List<Pair<MutableRegistry<?>, ?>> registriesList, RegistryOps.RegistryInfoGetter registryManager) {
        IdentityHashMap registries = new IdentityHashMap(registriesList.size());
        for (Pair<MutableRegistry<?>, ?> pair : registriesList) {
            registries.put(((MutableRegistry)pair.getFirst()).getKey(), (Registry)pair.getFirst());
        }
        ((DynamicRegistrySetupCallback)DynamicRegistrySetupCallback.EVENT.invoker()).onRegistrySetup(new DynamicRegistryViewImpl(registries));
    }

    @Inject(method={"getPath"}, at={@At(value="RETURN")}, cancellable=true)
    private static void prependDirectoryWithNamespace(Identifier id, CallbackInfoReturnable<String> info) {
        if (!id.getNamespace().equals("minecraft") && DynamicRegistriesImpl.FABRIC_DYNAMIC_REGISTRY_KEYS.contains(RegistryKey.ofRegistry((Identifier)id))) {
            String newPath = id.getNamespace() + "/" + (String)info.getReturnValue();
            info.setReturnValue((Object)newPath);
        }
    }
}

