/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.packet;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.zip.Deflater;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryPacketHandler {
    private int rawBufSize = 0;
    private int deflatedBufSize = 0;

    public abstract Identifier getPacketId();

    public abstract void sendPacket(ServerPlayerEntity var1, Map<Identifier, Object2IntMap<Identifier>> var2);

    public abstract void receivePacket(PacketByteBuf var1);

    public abstract int getTotalPacketReceived();

    public abstract boolean isPacketFinished();

    @Nullable
    public abstract Map<Identifier, Object2IntMap<Identifier>> getSyncedRegistryMap();

    protected final void sendPacket(ServerPlayerEntity player, PacketByteBuf buf) {
        ServerPlayNetworking.send((ServerPlayerEntity)player, (Identifier)this.getPacketId(), (PacketByteBuf)buf);
    }

    protected final void computeBufSize(PacketByteBuf buf) {
        if (!RegistrySyncManager.DEBUG) {
            return;
        }
        byte[] deflateBuffer = new byte[8192];
        ByteBuf byteBuf = buf.copy();
        Deflater deflater = new Deflater();
        int i = byteBuf.readableBytes();
        PacketByteBuf deflatedBuf = PacketByteBufs.create();
        if (i < 256) {
            deflatedBuf.writeVarInt(0);
            deflatedBuf.writeBytes(byteBuf);
        } else {
            byte[] bs = new byte[i];
            byteBuf.readBytes(bs);
            deflatedBuf.writeVarInt(bs.length);
            deflater.setInput(bs, 0, i);
            deflater.finish();
            while (!deflater.finished()) {
                int j = deflater.deflate(deflateBuffer);
                deflatedBuf.writeBytes(deflateBuffer, 0, j);
            }
            deflater.reset();
        }
        this.rawBufSize = buf.readableBytes();
        this.deflatedBufSize = deflatedBuf.readableBytes();
    }

    public final int getRawBufSize() {
        return this.rawBufSize;
    }

    public final int getDeflatedBufSize() {
        return this.deflatedBufSize;
    }
}

