/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.lifecycle.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientBlockEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.impl.event.lifecycle.LoadedChunksCache;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.packet.s2c.play.GameJoinS2CPacket;
import net.minecraft.network.packet.s2c.play.PlayerRespawnS2CPacket;
import net.minecraft.network.packet.s2c.play.SynchronizeTagsS2CPacket;
import net.minecraft.world.chunk.WorldChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ClientPlayNetworkHandler.class})
abstract class ClientPlayNetworkHandlerMixin {
    @Shadow
    private ClientWorld field_3699;

    ClientPlayNetworkHandlerMixin() {
    }

    @Inject(method={"onPlayerRespawn"}, at={@At(value="NEW", target="net/minecraft/client/world/ClientWorld")})
    private void onPlayerRespawn(PlayerRespawnS2CPacket packet, CallbackInfo ci) {
        if (this.field_3699 != null) {
            for (Entity entity : this.field_3699.getEntities()) {
                ((ClientEntityEvents.Unload)ClientEntityEvents.ENTITY_UNLOAD.invoker()).onUnload(entity, this.field_3699);
            }
            for (WorldChunk chunk : ((LoadedChunksCache)this.field_3699).fabric_getLoadedChunks()) {
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    ((ClientBlockEntityEvents.Unload)ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(blockEntity, this.field_3699);
                }
            }
        }
    }

    @Inject(method={"onGameJoin"}, at={@At(value="NEW", target="net/minecraft/client/world/ClientWorld")})
    private void onGameJoin(GameJoinS2CPacket packet, CallbackInfo ci) {
        if (this.field_3699 != null) {
            for (Entity entity : this.field_3699.getEntities()) {
                ((ClientEntityEvents.Unload)ClientEntityEvents.ENTITY_UNLOAD.invoker()).onUnload(entity, this.field_3699);
            }
            for (WorldChunk chunk : ((LoadedChunksCache)this.field_3699).fabric_getLoadedChunks()) {
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    ((ClientBlockEntityEvents.Unload)ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(blockEntity, this.field_3699);
                }
            }
        }
    }

    @Inject(method={"clearWorld"}, at={@At(value="HEAD")})
    private void onClearWorld(CallbackInfo ci) {
        if (this.field_3699 != null) {
            for (Entity entity : this.field_3699.getEntities()) {
                ((ClientEntityEvents.Unload)ClientEntityEvents.ENTITY_UNLOAD.invoker()).onUnload(entity, this.field_3699);
            }
            for (WorldChunk chunk : ((LoadedChunksCache)this.field_3699).fabric_getLoadedChunks()) {
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    ((ClientBlockEntityEvents.Unload)ClientBlockEntityEvents.BLOCK_ENTITY_UNLOAD.invoker()).onUnload(blockEntity, this.field_3699);
                }
            }
        }
    }

    @Inject(method={"onSynchronizeTags"}, at={@At(value="INVOKE", target="java/util/Map.forEach(Ljava/util/function/BiConsumer;)V", shift=At.Shift.AFTER, by=1)})
    private void hookOnSynchronizeTags(SynchronizeTagsS2CPacket packet, CallbackInfo ci) {
        ClientPlayNetworkHandler self = (ClientPlayNetworkHandler)this;
        ((CommonLifecycleEvents.TagsLoaded)CommonLifecycleEvents.TAGS_LOADED.invoker()).onTagsLoaded(self.getRegistryManager(), true);
    }
}

