/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.toast.Toast;
import net.minecraft.client.toast.ToastManager;
import net.minecraft.text.Text;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TutorialToast
implements Toast {
    public static final int PROGRESS_BAR_WIDTH = 154;
    public static final int PROGRESS_BAR_HEIGHT = 1;
    public static final int PROGRESS_BAR_X = 3;
    public static final int PROGRESS_BAR_Y = 28;
    private final Type type;
    private final Text title;
    @Nullable
    private final Text description;
    private Toast.Visibility visibility = Toast.Visibility.SHOW;
    private long lastTime;
    private float lastProgress;
    private float progress;
    private final boolean hasProgressBar;

    public TutorialToast(Type type, Text title, @Nullable Text description, boolean hasProgressBar) {
        this.type = type;
        this.title = title;
        this.description = description;
        this.hasProgressBar = hasProgressBar;
    }

    @Override
    public Toast.Visibility draw(DrawContext context, ToastManager manager, long startTime) {
        context.drawTexture(TEXTURE, 0, 0, 0, 96, this.getWidth(), this.getHeight());
        this.type.drawIcon(context, 6, 6);
        if (this.description == null) {
            context.drawText(manager.getClient().textRenderer, this.title, 30, 12, -11534256, false);
        } else {
            context.drawText(manager.getClient().textRenderer, this.title, 30, 7, -11534256, false);
            context.drawText(manager.getClient().textRenderer, this.description, 30, 18, -16777216, false);
        }
        if (this.hasProgressBar) {
            context.fill(3, 28, 157, 29, -1);
            float f = MathHelper.clampedLerp((float)this.lastProgress, (float)this.progress, (float)((float)(startTime - this.lastTime) / 100.0f));
            int i = this.progress >= this.lastProgress ? -16755456 : -11206656;
            context.fill(3, 28, (int)(3.0f + 154.0f * f), 29, i);
            this.lastProgress = f;
            this.lastTime = startTime;
        }
        return this.visibility;
    }

    public void hide() {
        this.visibility = Toast.Visibility.HIDE;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type MOVEMENT_KEYS = new Type(0, 0);
        public static final /* enum */ Type MOUSE = new Type(1, 0);
        public static final /* enum */ Type TREE = new Type(2, 0);
        public static final /* enum */ Type RECIPE_BOOK = new Type(0, 1);
        public static final /* enum */ Type WOODEN_PLANKS = new Type(1, 1);
        public static final /* enum */ Type SOCIAL_INTERACTIONS = new Type(2, 1);
        public static final /* enum */ Type RIGHT_CLICK = new Type(3, 1);
        private final int textureSlotX;
        private final int textureSlotY;
        private static final /* synthetic */ Type[] field_2234;

        public static Type[] values() {
            return (Type[])field_2234.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(int textureSlotX, int textureSlotY) {
            this.textureSlotX = textureSlotX;
            this.textureSlotY = textureSlotY;
        }

        public void drawIcon(DrawContext context, int x, int y) {
            RenderSystem.enableBlend();
            context.drawTexture(Toast.TEXTURE, x, y, 176 + this.textureSlotX * 20, this.textureSlotY * 20, 20, 20);
        }

        private static /* synthetic */ Type[] method_36873() {
            return new Type[]{MOVEMENT_KEYS, MOUSE, TREE, RECIPE_BOOK, WOODEN_PLANKS, SOCIAL_INTERACTIONS, RIGHT_CLICK};
        }

        static {
            field_2234 = Type.method_36873();
        }
    }
}

