/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity.feature;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.VertexConsumerProvider;
import net.minecraft.client.render.block.entity.SkullBlockEntityModel;
import net.minecraft.client.render.block.entity.SkullBlockEntityRenderer;
import net.minecraft.client.render.entity.feature.FeatureRenderer;
import net.minecraft.client.render.entity.feature.FeatureRendererContext;
import net.minecraft.client.render.entity.model.EntityModel;
import net.minecraft.client.render.entity.model.EntityModelLoader;
import net.minecraft.client.render.entity.model.ModelWithHead;
import net.minecraft.client.render.item.HeldItemRenderer;
import net.minecraft.client.render.model.json.ModelTransformationMode;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EquipmentSlot;
import net.minecraft.entity.LimbAnimator;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.mob.ZombieVillagerEntity;
import net.minecraft.entity.passive.VillagerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtHelper;
import net.minecraft.util.math.RotationAxis;

@Environment(value=EnvType.CLIENT)
public class HeadFeatureRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends FeatureRenderer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final Map<SkullBlock.SkullType, SkullBlockEntityModel> headModels;
    private final HeldItemRenderer heldItemRenderer;

    public HeadFeatureRenderer(FeatureRendererContext<T, M> context, EntityModelLoader loader, HeldItemRenderer heldItemRenderer) {
        this(context, loader, 1.0f, 1.0f, 1.0f, heldItemRenderer);
    }

    public HeadFeatureRenderer(FeatureRendererContext<T, M> context, EntityModelLoader loader, float scaleX, float scaleY, float scaleZ, HeldItemRenderer heldItemRenderer) {
        super(context);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.headModels = SkullBlockEntityRenderer.getModels(loader);
        this.heldItemRenderer = heldItemRenderer;
    }

    @Override
    public void render(MatrixStack matrixStack, VertexConsumerProvider vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        ArmorItem armorItem;
        float n;
        boolean bl;
        ItemStack itemStack = livingEntity.getEquippedStack(EquipmentSlot.HEAD);
        if (itemStack.isEmpty()) {
            return;
        }
        Item item = itemStack.getItem();
        matrixStack.push();
        matrixStack.scale(this.scaleX, this.scaleY, this.scaleZ);
        boolean bl2 = bl = livingEntity instanceof VillagerEntity || livingEntity instanceof ZombieVillagerEntity;
        if (livingEntity.isBaby() && !(livingEntity instanceof VillagerEntity)) {
            float m = 2.0f;
            n = 1.4f;
            matrixStack.translate(0.0f, 0.03125f, 0.0f);
            matrixStack.scale(0.7f, 0.7f, 0.7f);
            matrixStack.translate(0.0f, 1.0f, 0.0f);
        }
        ((ModelWithHead)this.getContextModel()).getHead().rotate(matrixStack);
        if (item instanceof BlockItem && ((BlockItem)item).getBlock() instanceof AbstractSkullBlock) {
            LimbAnimator limbAnimator;
            NbtCompound nbtCompound;
            n = 1.1875f;
            matrixStack.scale(1.1875f, -1.1875f, -1.1875f);
            if (bl) {
                matrixStack.translate(0.0f, 0.0625f, 0.0f);
            }
            GameProfile gameProfile = null;
            if (itemStack.hasNbt() && (nbtCompound = itemStack.getNbt()).contains("SkullOwner", 10)) {
                gameProfile = NbtHelper.toGameProfile((NbtCompound)nbtCompound.getCompound("SkullOwner"));
            }
            matrixStack.translate(-0.5, 0.0, -0.5);
            SkullBlock.SkullType skullType = ((AbstractSkullBlock)((BlockItem)item).getBlock()).getSkullType();
            SkullBlockEntityModel skullBlockEntityModel = this.headModels.get(skullType);
            RenderLayer renderLayer = SkullBlockEntityRenderer.getRenderLayer(skullType, gameProfile);
            Entity entity = livingEntity.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                limbAnimator = livingEntity2.limbAnimator;
            } else {
                limbAnimator = ((LivingEntity)livingEntity).limbAnimator;
            }
            float o = limbAnimator.getPos(h);
            SkullBlockEntityRenderer.renderSkull(null, 180.0f, o, matrixStack, vertexConsumerProvider, i, skullBlockEntityModel, renderLayer);
        } else if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).getSlotType() != EquipmentSlot.HEAD) {
            HeadFeatureRenderer.translate(matrixStack, bl);
            this.heldItemRenderer.renderItem((LivingEntity)livingEntity, itemStack, ModelTransformationMode.HEAD, false, matrixStack, vertexConsumerProvider, i);
        }
        matrixStack.pop();
    }

    public static void translate(MatrixStack matrices, boolean villager) {
        float f = 0.625f;
        matrices.translate(0.0f, -0.25f, 0.0f);
        matrices.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(180.0f));
        matrices.scale(0.625f, -0.625f, -0.625f);
        if (villager) {
            matrices.translate(0.0f, 0.1875f, 0.0f);
        }
    }
}

