/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity.animation;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.ModelPart;
import net.minecraft.client.render.entity.animation.Keyframe;
import net.minecraft.util.math.MathHelper;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public record Transformation(Target target, Keyframe[] keyframes) {

    @Environment(value=EnvType.CLIENT)
    public static interface Target {
        public void apply(ModelPart var1, Vector3f var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Interpolations {
        public static final Interpolation LINEAR = (dest, delta, keyframes, start, end, scale) -> {
            Vector3f vector3f = keyframes[start].target();
            Vector3f vector3f2 = keyframes[end].target();
            return vector3f.lerp((Vector3fc)vector3f2, delta, dest).mul(scale);
        };
        public static final Interpolation CUBIC = (dest, delta, keyframes, start, end, scale) -> {
            Vector3f vector3f = keyframes[Math.max(0, start - 1)].target();
            Vector3f vector3f2 = keyframes[start].target();
            Vector3f vector3f3 = keyframes[end].target();
            Vector3f vector3f4 = keyframes[Math.min(keyframes.length - 1, end + 1)].target();
            dest.set(MathHelper.catmullRom((float)delta, (float)vector3f.x(), (float)vector3f2.x(), (float)vector3f3.x(), (float)vector3f4.x()) * scale, MathHelper.catmullRom((float)delta, (float)vector3f.y(), (float)vector3f2.y(), (float)vector3f3.y(), (float)vector3f4.y()) * scale, MathHelper.catmullRom((float)delta, (float)vector3f.z(), (float)vector3f2.z(), (float)vector3f3.z(), (float)vector3f4.z()) * scale);
            return dest;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public static class Targets {
        public static final Target TRANSLATE = ModelPart::translate;
        public static final Target ROTATE = ModelPart::rotate;
        public static final Target SCALE = ModelPart::scale;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface Interpolation {
        public Vector3f apply(Vector3f var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }
}

