/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;

@Environment(value=EnvType.CLIENT)
public class ParticleTextureData {
    private final List<Identifier> textureList;

    private ParticleTextureData(List<Identifier> textureList) {
        this.textureList = textureList;
    }

    public List<Identifier> getTextureList() {
        return this.textureList;
    }

    public static ParticleTextureData load(JsonObject json) {
        JsonArray jsonArray = JsonHelper.getArray((JsonObject)json, (String)"textures", null);
        if (jsonArray == null) {
            return new ParticleTextureData(List.of());
        }
        List list = (List)Streams.stream((Iterable)jsonArray).map(texture -> JsonHelper.asString((JsonElement)texture, (String)"texture")).map(Identifier::new).collect(ImmutableList.toImmutableList());
        return new ParticleTextureData(list);
    }
}

