/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.item.ClampedModelPredicateProvider;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Position;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CompassAnglePredicateProvider
implements ClampedModelPredicateProvider {
    public static final int field_38798 = 0;
    private final AngleInterpolator aimedInterpolator = new AngleInterpolator();
    private final AngleInterpolator aimlessInterpolator = new AngleInterpolator();
    public final CompassTarget compassTarget;

    public CompassAnglePredicateProvider(CompassTarget compassTarget) {
        this.compassTarget = compassTarget;
    }

    @Override
    public float unclampedCall(ItemStack itemStack, @Nullable ClientWorld clientWorld, @Nullable LivingEntity livingEntity, int i) {
        LivingEntity entity;
        Object object = entity = livingEntity != null ? livingEntity : itemStack.getHolder();
        if (entity == null) {
            return 0.0f;
        }
        if ((clientWorld = this.getClientWorld((Entity)entity, clientWorld)) == null) {
            return 0.0f;
        }
        return this.getAngle(itemStack, clientWorld, i, (Entity)entity);
    }

    private float getAngle(ItemStack stack, ClientWorld world, int seed, Entity entity) {
        GlobalPos globalPos = this.compassTarget.getPos(world, stack, entity);
        long l = world.getTime();
        if (!this.canPointTo(entity, globalPos)) {
            return this.getAimlessAngle(seed, l);
        }
        return this.getAngleTo(entity, l, globalPos.getPos());
    }

    private float getAimlessAngle(int seed, long time) {
        if (this.aimlessInterpolator.shouldUpdate(time)) {
            this.aimlessInterpolator.update(time, Math.random());
        }
        double d = this.aimlessInterpolator.value + (double)((float)this.scatter(seed) / 2.1474836E9f);
        return MathHelper.floorMod((float)((float)d), (float)1.0f);
    }

    private float getAngleTo(Entity entity, long time, BlockPos pos) {
        double f;
        PlayerEntity playerEntity;
        double d = this.getAngleTo(entity, pos);
        double e = this.getBodyYaw(entity);
        if (entity instanceof PlayerEntity && (playerEntity = (PlayerEntity)entity).isMainPlayer()) {
            if (this.aimedInterpolator.shouldUpdate(time)) {
                this.aimedInterpolator.update(time, 0.5 - (e - 0.25));
            }
            f = d + this.aimedInterpolator.value;
        } else {
            f = 0.5 - (e - 0.25 - d);
        }
        return MathHelper.floorMod((float)((float)f), (float)1.0f);
    }

    @Nullable
    private ClientWorld getClientWorld(Entity entity, @Nullable ClientWorld world) {
        if (world == null && entity.getWorld() instanceof ClientWorld) {
            return (ClientWorld)entity.getWorld();
        }
        return world;
    }

    private boolean canPointTo(Entity entity, @Nullable GlobalPos pos) {
        return pos != null && pos.getDimension() == entity.getWorld().getRegistryKey() && !(pos.getPos().getSquaredDistance((Position)entity.getPos()) < (double)1.0E-5f);
    }

    private double getAngleTo(Entity entity, BlockPos pos) {
        Vec3d vec3d = Vec3d.ofCenter((Vec3i)pos);
        return Math.atan2(vec3d.getZ() - entity.getZ(), vec3d.getX() - entity.getX()) / 6.2831854820251465;
    }

    private double getBodyYaw(Entity entity) {
        return MathHelper.floorMod((double)(entity.getBodyYaw() / 360.0f), (double)1.0);
    }

    private int scatter(int seed) {
        return seed * 1327217883;
    }

    @Environment(value=EnvType.CLIENT)
    static class AngleInterpolator {
        double value;
        private double speed;
        private long lastUpdateTime;

        AngleInterpolator() {
        }

        boolean shouldUpdate(long time) {
            return this.lastUpdateTime != time;
        }

        void update(long time, double target) {
            this.lastUpdateTime = time;
            double d = target - this.value;
            d = MathHelper.floorMod((double)(d + 0.5), (double)1.0) - 0.5;
            this.speed += d * 0.1;
            this.speed *= 0.8;
            this.value = MathHelper.floorMod((double)(this.value + this.speed), (double)1.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface CompassTarget {
        @Nullable
        public GlobalPos getPos(ClientWorld var1, ItemStack var2, Entity var3);
    }
}

