/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen.ingame;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.block.entity.CommandBlockBlockEntity;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.ingame.AbstractCommandBlockScreen;
import net.minecraft.client.gui.widget.CyclingButtonWidget;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.play.UpdateCommandBlockC2SPacket;
import net.minecraft.text.Text;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Position;
import net.minecraft.world.CommandBlockExecutor;

@Environment(value=EnvType.CLIENT)
public class CommandBlockScreen
extends AbstractCommandBlockScreen {
    private final CommandBlockBlockEntity blockEntity;
    private CyclingButtonWidget<CommandBlockBlockEntity.Type> modeButton;
    private CyclingButtonWidget<Boolean> conditionalModeButton;
    private CyclingButtonWidget<Boolean> redstoneTriggerButton;
    private CommandBlockBlockEntity.Type mode = CommandBlockBlockEntity.Type.REDSTONE;
    private boolean conditional;
    private boolean autoActivate;

    public CommandBlockScreen(CommandBlockBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    CommandBlockExecutor getCommandExecutor() {
        return this.blockEntity.getCommandExecutor();
    }

    @Override
    int getTrackOutputButtonHeight() {
        return 135;
    }

    @Override
    protected void init() {
        super.init();
        this.modeButton = this.addDrawableChild(CyclingButtonWidget.builder(value -> switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case CommandBlockBlockEntity.Type.SEQUENCE -> Text.translatable((String)"advMode.mode.sequence");
            case CommandBlockBlockEntity.Type.AUTO -> Text.translatable((String)"advMode.mode.auto");
            case CommandBlockBlockEntity.Type.REDSTONE -> Text.translatable((String)"advMode.mode.redstone");
        }).values((CommandBlockBlockEntity.Type[])CommandBlockBlockEntity.Type.values()).omitKeyText().initially(this.mode).build(this.width / 2 - 50 - 100 - 4, 165, 100, 20, (Text)Text.translatable((String)"advMode.mode"), (button, mode) -> {
            this.mode = mode;
        }));
        this.conditionalModeButton = this.addDrawableChild(CyclingButtonWidget.onOffBuilder((Text)Text.translatable((String)"advMode.mode.conditional"), (Text)Text.translatable((String)"advMode.mode.unconditional")).omitKeyText().initially(this.conditional).build(this.width / 2 - 50, 165, 100, 20, (Text)Text.translatable((String)"advMode.type"), (button, conditional) -> {
            this.conditional = conditional;
        }));
        this.redstoneTriggerButton = this.addDrawableChild(CyclingButtonWidget.onOffBuilder((Text)Text.translatable((String)"advMode.mode.autoexec.bat"), (Text)Text.translatable((String)"advMode.mode.redstoneTriggered")).omitKeyText().initially(this.autoActivate).build(this.width / 2 + 50 + 4, 165, 100, 20, (Text)Text.translatable((String)"advMode.triggering"), (button, autoActivate) -> {
            this.autoActivate = autoActivate;
        }));
        this.setButtonsActive(false);
    }

    private void setButtonsActive(boolean active) {
        this.doneButton.active = active;
        this.toggleTrackingOutputButton.active = active;
        this.modeButton.active = active;
        this.conditionalModeButton.active = active;
        this.redstoneTriggerButton.active = active;
    }

    public void updateCommandBlock() {
        CommandBlockExecutor commandBlockExecutor = this.blockEntity.getCommandExecutor();
        this.consoleCommandTextField.setText(commandBlockExecutor.getCommand());
        boolean bl = commandBlockExecutor.isTrackingOutput();
        this.mode = this.blockEntity.getCommandBlockType();
        this.conditional = this.blockEntity.isConditionalCommandBlock();
        this.autoActivate = this.blockEntity.isAuto();
        this.toggleTrackingOutputButton.setValue(bl);
        this.modeButton.setValue(this.mode);
        this.conditionalModeButton.setValue(this.conditional);
        this.redstoneTriggerButton.setValue(this.autoActivate);
        this.setPreviousOutputText(bl);
        this.setButtonsActive(true);
    }

    @Override
    public void resize(MinecraftClient client, int width, int height) {
        super.resize(client, width, height);
        this.setButtonsActive(true);
    }

    @Override
    protected void syncSettingsToServer(CommandBlockExecutor commandExecutor) {
        this.client.getNetworkHandler().sendPacket((Packet<?>)new UpdateCommandBlockC2SPacket(BlockPos.ofFloored((Position)commandExecutor.getPos()), this.consoleCommandTextField.getText(), this.mode, commandExecutor.isTrackingOutput(), this.conditional, this.autoActivate));
    }
}

