/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.network.ServerAddress;
import net.minecraft.client.network.ServerInfo;
import net.minecraft.screen.ScreenTexts;
import net.minecraft.text.Text;

@Environment(value=EnvType.CLIENT)
public class DirectConnectScreen
extends Screen {
    private static final Text ENTER_IP_TEXT = Text.translatable((String)"addServer.enterIp");
    private ButtonWidget selectServerButton;
    private final ServerInfo serverEntry;
    private TextFieldWidget addressField;
    private final BooleanConsumer callback;
    private final Screen parent;

    public DirectConnectScreen(Screen parent, BooleanConsumer callback, ServerInfo server) {
        super((Text)Text.translatable((String)"selectServer.direct"));
        this.parent = parent;
        this.serverEntry = server;
        this.callback = callback;
    }

    @Override
    public void tick() {
        this.addressField.tick();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.selectServerButton.active && this.getFocused() == this.addressField && (keyCode == 257 || keyCode == 335)) {
            this.saveAndClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void init() {
        this.addressField = new TextFieldWidget(this.textRenderer, this.width / 2 - 100, 116, 200, 20, (Text)Text.translatable((String)"addServer.enterIp"));
        this.addressField.setMaxLength(128);
        this.addressField.setText(this.client.options.lastServer);
        this.addressField.setChangedListener(text -> this.onAddressFieldChanged());
        this.addSelectableChild(this.addressField);
        this.selectServerButton = this.addDrawableChild(ButtonWidget.builder((Text)Text.translatable((String)"selectServer.select"), button -> this.saveAndClose()).dimensions(this.width / 2 - 100, this.height / 4 + 96 + 12, 200, 20).build());
        this.addDrawableChild(ButtonWidget.builder(ScreenTexts.CANCEL, button -> this.callback.accept(false)).dimensions(this.width / 2 - 100, this.height / 4 + 120 + 12, 200, 20).build());
        this.setInitialFocus(this.addressField);
        this.onAddressFieldChanged();
    }

    @Override
    public void resize(MinecraftClient client, int width, int height) {
        String string = this.addressField.getText();
        this.init(client, width, height);
        this.addressField.setText(string);
    }

    private void saveAndClose() {
        this.serverEntry.address = this.addressField.getText();
        this.callback.accept(true);
    }

    @Override
    public void close() {
        this.client.setScreen(this.parent);
    }

    @Override
    public void removed() {
        this.client.options.lastServer = this.addressField.getText();
        this.client.options.write();
    }

    private void onAddressFieldChanged() {
        this.selectServerButton.active = ServerAddress.isValid(this.addressField.getText());
    }

    @Override
    public void render(DrawContext context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context);
        context.drawCenteredTextWithShadow(this.textRenderer, this.title, this.width / 2, 20, 0xFFFFFF);
        context.drawTextWithShadow(this.textRenderer, ENTER_IP_TEXT, this.width / 2 - 100, 100, 0xA0A0A0);
        this.addressField.render(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
    }
}

