/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.font;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.font.Font;
import net.minecraft.client.font.FontLoader;
import net.minecraft.client.font.FontType;
import net.minecraft.client.font.TrueTypeFont;
import net.minecraft.resource.ResourceManager;
import net.minecraft.util.Identifier;
import net.minecraft.util.Util;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public record TrueTypeFontLoader(Identifier location, float size, float oversample, Shift shift, String skip) implements FontLoader
{
    private static final Codec<String> SKIP_CODEC = Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).xmap(either -> (String)either.map(string -> string, list -> String.join((CharSequence)"", list)), Either::left);
    public static final MapCodec<TrueTypeFontLoader> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Identifier.CODEC.fieldOf("file").forGetter(TrueTypeFontLoader::location), (App)Codec.FLOAT.optionalFieldOf("size", (Object)Float.valueOf(11.0f)).forGetter(TrueTypeFontLoader::size), (App)Codec.FLOAT.optionalFieldOf("oversample", (Object)Float.valueOf(1.0f)).forGetter(TrueTypeFontLoader::oversample), (App)Shift.CODEC.optionalFieldOf("shift", (Object)Shift.NONE).forGetter(TrueTypeFontLoader::shift), (App)SKIP_CODEC.optionalFieldOf("skip", (Object)"").forGetter(TrueTypeFontLoader::skip)).apply((Applicative)instance, TrueTypeFontLoader::new));

    @Override
    public FontType getType() {
        return FontType.TTF;
    }

    @Override
    public Either<FontLoader.Loadable, FontLoader.Reference> build() {
        return Either.left(this::load);
    }

    private Font load(ResourceManager resourceManager) throws IOException {
        TrueTypeFont trueTypeFont;
        block10: {
            STBTTFontinfo sTBTTFontinfo = null;
            ByteBuffer byteBuffer = null;
            InputStream inputStream = resourceManager.open(this.location.withPrefixedPath("font/"));
            try {
                sTBTTFontinfo = STBTTFontinfo.malloc();
                byteBuffer = TextureUtil.readResource(inputStream);
                byteBuffer.flip();
                if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)sTBTTFontinfo, (ByteBuffer)byteBuffer)) {
                    throw new IOException("Invalid ttf");
                }
                trueTypeFont = new TrueTypeFont(byteBuffer, sTBTTFontinfo, this.size, this.oversample, this.shift.x, this.shift.y, this.skip);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (sTBTTFontinfo != null) {
                        sTBTTFontinfo.free();
                    }
                    MemoryUtil.memFree(byteBuffer);
                    throw exception;
                }
            }
            inputStream.close();
        }
        return trueTypeFont;
    }

    @Environment(value=EnvType.CLIENT)
    public static final class Shift
    extends Record {
        final float x;
        final float y;
        public static final Shift NONE = new Shift(0.0f, 0.0f);
        public static final Codec<Shift> CODEC = Codec.FLOAT.listOf().comapFlatMap(floatList2 -> Util.decodeFixedLengthList((List)floatList2, (int)2).map(floatList -> new Shift(((Float)floatList.get(0)).floatValue(), ((Float)floatList.get(1)).floatValue())), shift -> List.of(Float.valueOf(shift.x), Float.valueOf(shift.y)));

        public Shift(float f, float g) {
            this.x = f;
            this.y = g;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Shift.class, "x;y", "x", "y"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Shift.class, "x;y", "x", "y"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Shift.class, "x;y", "x", "y"}, this, object);
        }

        public float x() {
            return this.x;
        }

        public float y() {
            return this.y;
        }
    }
}

