/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.font;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.font.Font;
import net.minecraft.client.font.FontLoader;
import net.minecraft.client.font.FontType;
import net.minecraft.client.font.Glyph;
import net.minecraft.client.font.GlyphContainer;
import net.minecraft.client.font.GlyphRenderer;
import net.minecraft.client.font.RenderableGlyph;
import net.minecraft.client.texture.NativeImage;
import net.minecraft.resource.ResourceManager;
import net.minecraft.util.Identifier;
import net.minecraft.util.dynamic.Codecs;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class BitmapFont
implements Font {
    static final Logger LOGGER = LogUtils.getLogger();
    private final NativeImage image;
    private final GlyphContainer<BitmapFontGlyph> glyphs;

    BitmapFont(NativeImage image, GlyphContainer<BitmapFontGlyph> glyphs) {
        this.image = image;
        this.glyphs = glyphs;
    }

    @Override
    public void close() {
        this.image.close();
    }

    @Override
    @Nullable
    public Glyph getGlyph(int codePoint) {
        return this.glyphs.get(codePoint);
    }

    @Override
    public IntSet getProvidedGlyphs() {
        return IntSets.unmodifiable((IntSet)this.glyphs.getProvidedGlyphs());
    }

    @Environment(value=EnvType.CLIENT)
    static final class BitmapFontGlyph
    extends Record
    implements Glyph {
        final float scaleFactor;
        final NativeImage image;
        final int x;
        final int y;
        final int width;
        final int height;
        private final int advance;
        final int ascent;

        BitmapFontGlyph(float scaleFactor, NativeImage image, int x, int y, int width, int height, int advance, int ascent) {
            this.scaleFactor = scaleFactor;
            this.image = image;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.advance = advance;
            this.ascent = ascent;
        }

        @Override
        public float getAdvance() {
            return this.advance;
        }

        @Override
        public GlyphRenderer bake(Function<RenderableGlyph, GlyphRenderer> function) {
            return function.apply(new RenderableGlyph(){

                @Override
                public float getOversample() {
                    return 1.0f / scaleFactor;
                }

                @Override
                public int getWidth() {
                    return width;
                }

                @Override
                public int getHeight() {
                    return height;
                }

                @Override
                public float getAscent() {
                    return RenderableGlyph.super.getAscent() + 7.0f - (float)ascent;
                }

                @Override
                public void upload(int x, int y) {
                    image.upload(0, x, y, x, y, width, height, false, false);
                }

                @Override
                public boolean hasColor() {
                    return image.getFormat().getChannelCount() > 1;
                }
            });
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BitmapFontGlyph.class, "scale;image;offsetX;offsetY;width;height;advance;ascent", "scaleFactor", "image", "x", "y", "width", "height", "advance", "ascent"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BitmapFontGlyph.class, "scale;image;offsetX;offsetY;width;height;advance;ascent", "scaleFactor", "image", "x", "y", "width", "height", "advance", "ascent"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BitmapFontGlyph.class, "scale;image;offsetX;offsetY;width;height;advance;ascent", "scaleFactor", "image", "x", "y", "width", "height", "advance", "ascent"}, this, object);
        }

        public float scaleFactor() {
            return this.scaleFactor;
        }

        public NativeImage image() {
            return this.image;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public int advance() {
            return this.advance;
        }

        public int ascent() {
            return this.ascent;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Loader(Identifier file, int height, int ascent, int[][] codepointGrid) implements FontLoader
    {
        private static final Codec<int[][]> CODE_POINT_GRID_CODEC = Codecs.validate((Codec)Codec.STRING.listOf().xmap(strings -> {
            int i = strings.size();
            int[][] is = new int[i][];
            for (int j = 0; j < i; ++j) {
                is[j] = ((String)strings.get(j)).codePoints().toArray();
            }
            return is;
        }, codePointGrid -> {
            ArrayList<String> list = new ArrayList<String>(((int[][])codePointGrid).length);
            for (int[] is : codePointGrid) {
                list.add(new String(is, 0, is.length));
            }
            return list;
        }), Loader::validateCodePointGrid);
        public static final MapCodec<Loader> CODEC = Codecs.validate((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Identifier.CODEC.fieldOf("file").forGetter(Loader::file), (App)Codec.INT.optionalFieldOf("height", (Object)8).forGetter(Loader::height), (App)Codec.INT.fieldOf("ascent").forGetter(Loader::ascent), (App)CODE_POINT_GRID_CODEC.fieldOf("chars").forGetter(Loader::codepointGrid)).apply((Applicative)instance, Loader::new)), Loader::validate);

        private static DataResult<int[][]> validateCodePointGrid(int[][] codePointGrid) {
            int i = codePointGrid.length;
            if (i == 0) {
                return DataResult.error(() -> "Expected to find data in codepoint grid");
            }
            int[] is = codePointGrid[0];
            int j = is.length;
            if (j == 0) {
                return DataResult.error(() -> "Expected to find data in codepoint grid");
            }
            for (int k = 1; k < i; ++k) {
                int[] js = codePointGrid[k];
                if (js.length == j) continue;
                return DataResult.error(() -> "Lines in codepoint grid have to be the same length (found: " + js.length + " codepoints, expected: " + j + "), pad with \\u0000");
            }
            return DataResult.success((Object)codePointGrid);
        }

        private static DataResult<Loader> validate(Loader fontLoader) {
            if (fontLoader.ascent > fontLoader.height) {
                return DataResult.error(() -> "Ascent " + loader.ascent + " higher than height " + loader.height);
            }
            return DataResult.success((Object)fontLoader);
        }

        @Override
        public FontType getType() {
            return FontType.BITMAP;
        }

        @Override
        public Either<FontLoader.Loadable, FontLoader.Reference> build() {
            return Either.left(this::load);
        }

        private Font load(ResourceManager resourceManager) throws IOException {
            Identifier identifier = this.file.withPrefixedPath("textures/");
            try (InputStream inputStream = resourceManager.open(identifier);){
                NativeImage nativeImage = NativeImage.read(NativeImage.Format.RGBA, inputStream);
                int i2 = nativeImage.getWidth();
                int j = nativeImage.getHeight();
                int k = i2 / this.codepointGrid[0].length;
                int l = j / this.codepointGrid.length;
                float f = (float)this.height / (float)l;
                GlyphContainer<BitmapFontGlyph> glyphContainer = new GlyphContainer<BitmapFontGlyph>(BitmapFontGlyph[]::new, i -> new BitmapFontGlyph[i][]);
                for (int m = 0; m < this.codepointGrid.length; ++m) {
                    int n = 0;
                    for (int o : this.codepointGrid[m]) {
                        int q;
                        BitmapFontGlyph bitmapFontGlyph;
                        int p = n++;
                        if (o == 0 || (bitmapFontGlyph = glyphContainer.put(o, new BitmapFontGlyph(f, nativeImage, p * k, m * l, k, l, (int)(0.5 + (double)((float)(q = this.findCharacterStartX(nativeImage, k, l, p, m)) * f)) + 1, this.ascent))) == null) continue;
                        LOGGER.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString(o), (Object)identifier);
                    }
                }
                BitmapFont bitmapFont = new BitmapFont(nativeImage, glyphContainer);
                return bitmapFont;
            }
        }

        private int findCharacterStartX(NativeImage image, int characterWidth, int characterHeight, int charPosX, int charPosY) {
            int i;
            for (i = characterWidth - 1; i >= 0; --i) {
                int j = charPosX * characterWidth + i;
                for (int k = 0; k < characterHeight; ++k) {
                    int l = charPosY * characterHeight + k;
                    if (image.getOpacity(j, l) == 0) continue;
                    return i + 1;
                }
            }
            return i + 1;
        }
    }
}

