/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.s2c.play.CustomPayloadS2CPacket;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ClientPlayNetworking.PlayChannelHandler> {
    private final ClientPlayNetworkHandler handler;
    private final MinecraftClient client;
    private boolean sentInitialRegisterPacket;
    private static final Logger LOGGER = LogUtils.getLogger();

    public ClientPlayNetworkAddon(ClientPlayNetworkHandler handler, MinecraftClient client) {
        super(ClientNetworkingImpl.PLAY, handler.getConnection(), "ClientPlayNetworkAddon for " + handler.getProfile().getName());
        this.handler = handler;
        this.client = client;
        this.registerPendingChannels((ChannelInfoHolder)this.connection);
        this.receiver.startSession((AbstractNetworkAddon)this);
    }

    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel((Identifier)entry.getKey(), (ClientPlayNetworking.PlayChannelHandler)entry.getValue());
        }
        ((ClientPlayConnectionEvents.Init)ClientPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.client);
    }

    public void onServerReady() {
        try {
            ((ClientPlayConnectionEvents.Join)ClientPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, (PacketSender)this, this.client);
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception thrown while invoking ClientPlayConnectionEvents.JOIN", (Throwable)e);
        }
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(CustomPayloadS2CPacket packet) {
        PacketByteBuf buf = packet.getData();
        try {
            boolean bl = this.handle(packet.getChannel(), buf);
            return bl;
        }
        finally {
            buf.release();
        }
    }

    protected void receive(ClientPlayNetworking.PlayChannelHandler handler, PacketByteBuf buf) {
        handler.receive(this.client, this.handler, buf, (PacketSender)this);
    }

    protected void schedule(Runnable task) {
        MinecraftClient.getInstance().execute(task);
    }

    public Packet<?> createPacket(Identifier channelName, PacketByteBuf buf) {
        return ClientPlayNetworking.createC2SPacket(channelName, buf);
    }

    protected void invokeRegisterEvent(List<Identifier> ids) {
        ((C2SPlayChannelEvents.Register)C2SPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, (PacketSender)this, this.client, ids);
    }

    protected void invokeUnregisterEvent(List<Identifier> ids) {
        ((C2SPlayChannelEvents.Unregister)C2SPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, (PacketSender)this, this.client, ids);
    }

    protected void handleRegistration(Identifier channelName) {
        PacketByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    protected void handleUnregistration(Identifier channelName) {
        PacketByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    protected void invokeDisconnectEvent() {
        ((ClientPlayConnectionEvents.Disconnect)ClientPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.client);
        this.receiver.endSession((AbstractNetworkAddon)this);
    }

    protected boolean isReservedChannel(Identifier channelName) {
        return NetworkingImpl.isReservedPlayChannel((Identifier)channelName);
    }
}

