/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.block.Block;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.DataWriter;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.attribute.EntityAttribute;
import net.minecraft.entity.effect.StatusEffect;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.registry.Registries;
import net.minecraft.registry.RegistryKey;
import net.minecraft.stat.StatType;
import net.minecraft.text.TextContent;
import net.minecraft.text.TranslatableTextContent;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.ApiStatus;

public abstract class FabricLanguageProvider
implements DataProvider {
    protected final FabricDataOutput dataOutput;
    private final String languageCode;

    protected FabricLanguageProvider(FabricDataOutput dataOutput) {
        this(dataOutput, "en_us");
    }

    protected FabricLanguageProvider(FabricDataOutput dataOutput, String languageCode) {
        this.dataOutput = dataOutput;
        this.languageCode = languageCode;
    }

    public abstract void generateTranslations(TranslationBuilder var1);

    public CompletableFuture<?> run(DataWriter writer) {
        TreeMap translationEntries = new TreeMap();
        this.generateTranslations((key, value) -> {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            if (translationEntries.containsKey(key)) {
                throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
            }
            translationEntries.put(key, value);
        });
        JsonObject langEntryJson = new JsonObject();
        for (Map.Entry entry : translationEntries.entrySet()) {
            langEntryJson.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return DataProvider.writeToPath((DataWriter)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.getResolver(DataOutput.OutputType.RESOURCE_PACK, "lang").resolveJson(new Identifier(this.dataOutput.getModId(), code));
    }

    public String getName() {
        return "Language (%s)".formatted(this.languageCode);
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface TranslationBuilder {
        public void add(String var1, String var2);

        default public void add(Item item, String value) {
            this.add(item.getTranslationKey(), value);
        }

        default public void add(Block block, String value) {
            this.add(block.getTranslationKey(), value);
        }

        default public void add(RegistryKey<ItemGroup> registryKey, String value) {
            ItemGroup group = (ItemGroup)Registries.ITEM_GROUP.getOrThrow(registryKey);
            TextContent content = group.getDisplayName().getContent();
            if (content instanceof TranslatableTextContent) {
                TranslatableTextContent translatableTextContent = (TranslatableTextContent)content;
                this.add(translatableTextContent.getKey(), value);
                return;
            }
            throw new UnsupportedOperationException("Cannot add language entry for ItemGroup (%s) as the display name is not translatable.".formatted(group.getDisplayName().getString()));
        }

        default public void add(EntityType<?> entityType, String value) {
            this.add(entityType.getTranslationKey(), value);
        }

        default public void add(Enchantment enchantment, String value) {
            this.add(enchantment.getTranslationKey(), value);
        }

        default public void add(EntityAttribute entityAttribute, String value) {
            this.add(entityAttribute.getTranslationKey(), value);
        }

        default public void add(StatType<?> statType, String value) {
            this.add(statType.getTranslationKey(), value);
        }

        default public void add(StatusEffect statusEffect, String value) {
            this.add(statusEffect.getTranslationKey(), value);
        }

        default public void add(Identifier identifier, String value) {
            this.add(identifier.toTranslationKey(), value);
        }

        default public void add(Path existingLanguageFile) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(existingLanguageFile);){
                JsonObject translations = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (String key : translations.keySet()) {
                    this.add(key, translations.get(key).getAsString());
                }
            }
        }
    }
}

