/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.advancement.Advancement;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.DataWriter;

public abstract class FabricAdvancementProvider
implements DataProvider {
    protected final FabricDataOutput output;
    private final DataOutput.PathResolver pathResolver;

    protected FabricAdvancementProvider(FabricDataOutput output) {
        this.output = output;
        this.pathResolver = output.getResolver(DataOutput.OutputType.DATA_PACK, "advancements");
    }

    public abstract void generateAdvancement(Consumer<Advancement> var1);

    protected Consumer<Advancement> withConditions(Consumer<Advancement> exporter, ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return advancement -> {
            FabricDataGenHelper.addConditions(advancement, conditions);
            exporter.accept((Advancement)advancement);
        };
    }

    public CompletableFuture<?> run(DataWriter writer) {
        HashSet identifiers = Sets.newHashSet();
        HashSet advancements = Sets.newHashSet();
        this.generateAdvancement(advancements::add);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Advancement advancement : advancements) {
            if (!identifiers.add(advancement.getId())) {
                throw new IllegalStateException("Duplicate advancement " + String.valueOf(advancement.getId()));
            }
            JsonObject advancementJson = advancement.createTask().toJson();
            ConditionJsonProvider.write((JsonObject)advancementJson, (ConditionJsonProvider[])FabricDataGenHelper.consumeConditions(advancement));
            futures.add(DataProvider.writeToPath((DataWriter)writer, (JsonElement)advancementJson, (Path)this.getOutputPath(advancement)));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private Path getOutputPath(Advancement advancement) {
        return this.pathResolver.resolveJson(advancement.getId());
    }

    public String getName() {
        return "Advancements";
    }
}

