/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.impl.client.model.loading.BlockStateResolverHolder;
import net.fabricmc.fabric.impl.client.model.loading.LegacyModelVariantProvider;
import net.minecraft.block.Block;
import net.minecraft.client.render.model.UnbakedModel;
import net.minecraft.client.util.ModelIdentifier;
import net.minecraft.registry.Registries;
import net.minecraft.registry.RegistryKey;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModelLoaderPluginContextImpl
implements ModelLoadingPlugin.Context {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoaderPluginContextImpl.class);
    final Set<Identifier> extraModels = new LinkedHashSet<Identifier>();
    private final Map<BlockKey, BlockStateResolverHolder> blockStateResolvers = new HashMap<BlockKey, BlockStateResolverHolder>();
    private final BlockKey lookupKey = new BlockKey();
    private final Event<ModelResolver> modelResolvers = EventFactory.createArrayBacked(ModelResolver.class, resolvers -> context -> {
        for (ModelResolver resolver : resolvers) {
            try {
                UnbakedModel model = resolver.resolveModel(context);
                if (model == null) continue;
                return model;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to resolve model", (Throwable)exception);
            }
        }
        return null;
    });
    private static final Identifier[] MODEL_MODIFIER_PHASES = new Identifier[]{ModelModifier.OVERRIDE_PHASE, ModelModifier.DEFAULT_PHASE, ModelModifier.WRAP_PHASE, ModelModifier.WRAP_LAST_PHASE};
    private final Event<ModelModifier.OnLoad> onLoadModifiers = EventFactory.createWithPhases(ModelModifier.OnLoad.class, modifiers -> (model, context) -> {
        for (ModelModifier.OnLoad modifier : modifiers) {
            try {
                model = modifier.modifyModelOnLoad(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked model on load", (Throwable)exception);
            }
        }
        return model;
    }, (Identifier[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.BeforeBake> beforeBakeModifiers = EventFactory.createWithPhases(ModelModifier.BeforeBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.BeforeBake modifier : modifiers) {
            try {
                model = modifier.modifyModelBeforeBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify unbaked model before bake", (Throwable)exception);
            }
        }
        return model;
    }, (Identifier[])MODEL_MODIFIER_PHASES);
    private final Event<ModelModifier.AfterBake> afterBakeModifiers = EventFactory.createWithPhases(ModelModifier.AfterBake.class, modifiers -> (model, context) -> {
        for (ModelModifier.AfterBake modifier : modifiers) {
            try {
                model = modifier.modifyModelAfterBake(model, context);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to modify baked model after bake", (Throwable)exception);
            }
        }
        return model;
    }, (Identifier[])MODEL_MODIFIER_PHASES);
    public final Function<Identifier, UnbakedModel> modelGetter;
    private final Event<LegacyModelVariantProvider> legacyVariantProviders = EventFactory.createArrayBacked(LegacyModelVariantProvider.class, providers -> modelId -> {
        for (LegacyModelVariantProvider provider : providers) {
            try {
                UnbakedModel model = provider.loadModelVariant(modelId);
                if (model == null) continue;
                return model;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to run legacy model variant provider", (Throwable)exception);
            }
        }
        return null;
    });

    public ModelLoaderPluginContextImpl(Function<Identifier, UnbakedModel> modelGetter) {
        this.modelGetter = modelGetter;
    }

    @Override
    public void addModels(Identifier ... ids) {
        for (Identifier id : ids) {
            this.extraModels.add(id);
        }
    }

    @Override
    public void addModels(Collection<? extends Identifier> ids) {
        this.extraModels.addAll(ids);
    }

    @Override
    public void registerBlockStateResolver(Block block, BlockStateResolver resolver) {
        BlockStateResolverHolder holder;
        Objects.requireNonNull(block, "block cannot be null");
        Objects.requireNonNull(resolver, "resolver cannot be null");
        Optional optionalKey = Registries.BLOCK.getKey((Object)block);
        if (optionalKey.isEmpty()) {
            throw new IllegalArgumentException("Received unregistered block");
        }
        Identifier blockId = ((RegistryKey)optionalKey.get()).getValue();
        BlockKey key = new BlockKey(blockId.getNamespace(), blockId.getPath());
        if (this.blockStateResolvers.put(key, holder = new BlockStateResolverHolder(resolver, block, blockId)) != null) {
            throw new IllegalArgumentException("Duplicate block state resolver for block " + String.valueOf(blockId));
        }
    }

    @Nullable
    BlockStateResolverHolder getBlockStateResolver(ModelIdentifier modelId) {
        BlockKey key = this.lookupKey;
        key.namespace = modelId.getNamespace();
        key.path = modelId.getPath();
        return this.blockStateResolvers.get(key);
    }

    @Override
    public Event<ModelResolver> resolveModel() {
        return this.modelResolvers;
    }

    @Override
    public Event<ModelModifier.OnLoad> modifyModelOnLoad() {
        return this.onLoadModifiers;
    }

    @Override
    public Event<ModelModifier.BeforeBake> modifyModelBeforeBake() {
        return this.beforeBakeModifiers;
    }

    @Override
    public Event<ModelModifier.AfterBake> modifyModelAfterBake() {
        return this.afterBakeModifiers;
    }

    public Event<LegacyModelVariantProvider> legacyVariantProviders() {
        return this.legacyVariantProviders;
    }

    @Environment(value=EnvType.CLIENT)
    private static class BlockKey {
        private String namespace;
        private String path;

        private BlockKey() {
        }

        private BlockKey(String namespace, String path) {
            this.namespace = namespace;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockKey blockKey = (BlockKey)o;
            return this.namespace.equals(blockKey.namespace) && this.path.equals(blockKey.path);
        }

        public int hashCode() {
            return 31 * this.namespace.hashCode() + this.path.hashCode();
        }
    }
}

