/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.event.interaction.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.client.network.ClientPlayerInteractionManager;
import net.minecraft.client.network.SequencedPacketCreator;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.play.PlayerActionC2SPacket;
import net.minecraft.network.packet.c2s.play.PlayerInteractBlockC2SPacket;
import net.minecraft.network.packet.c2s.play.PlayerInteractEntityC2SPacket;
import net.minecraft.network.packet.c2s.play.PlayerInteractItemC2SPacket;
import net.minecraft.network.packet.c2s.play.PlayerMoveC2SPacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.TypedActionResult;
import net.minecraft.util.hit.BlockHitResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.world.GameMode;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ClientPlayerInteractionManager.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private MinecraftClient field_3712;
    @Shadow
    @Final
    private ClientPlayNetworkHandler field_3720;
    @Shadow
    private GameMode field_3719;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/GameMode;isCreative()Z", ordinal=0)}, method={"attackBlock"}, cancellable=true)
    public void attackBlock(BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> info) {
        this.fabric_fireAttackBlockCallback(pos, direction, info);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/GameMode;isCreative()Z", ordinal=0)}, method={"updateBlockBreakingProgress"}, cancellable=true)
    public void method_2902(BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> info) {
        if (this.field_3719.isCreative()) {
            this.fabric_fireAttackBlockCallback(pos, direction, info);
        }
    }

    @Unique
    private void fabric_fireAttackBlockCallback(BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> info) {
        ActionResult result = ((AttackBlockCallback)AttackBlockCallback.EVENT.invoker()).interact((PlayerEntity)this.field_3712.player, (World)this.field_3712.world, Hand.MAIN_HAND, pos, direction);
        if (result != ActionResult.PASS) {
            info.setReturnValue((Object)(result == ActionResult.SUCCESS ? 1 : 0));
            if (result.isAccepted()) {
                this.method_41931(this.field_3712.world, id -> new PlayerActionC2SPacket(PlayerActionC2SPacket.Action.START_DESTROY_BLOCK, pos, direction, id));
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;sendSequencedPacket(Lnet/minecraft/client/world/ClientWorld;Lnet/minecraft/client/network/SequencedPacketCreator;)V")}, method={"interactBlock"}, cancellable=true)
    public void interactBlock(ClientPlayerEntity player, Hand hand, BlockHitResult blockHitResult, CallbackInfoReturnable<ActionResult> info) {
        if (player.isSpectator()) {
            return;
        }
        ActionResult result = ((UseBlockCallback)UseBlockCallback.EVENT.invoker()).interact((PlayerEntity)player, player.getWorld(), hand, blockHitResult);
        if (result != ActionResult.PASS) {
            if (result == ActionResult.SUCCESS) {
                this.method_41931(player.clientWorld, id -> new PlayerInteractBlockC2SPacket(hand, blockHitResult, id));
            }
            info.setReturnValue((Object)result);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V", ordinal=0)}, method={"interactItem"}, cancellable=true)
    public void interactItem(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResult> info) {
        TypedActionResult<ItemStack> result = ((UseItemCallback)UseItemCallback.EVENT.invoker()).interact(player, player.getWorld(), hand);
        if (result.getResult() != ActionResult.PASS) {
            if (result.getResult() == ActionResult.SUCCESS) {
                this.field_3720.sendPacket((Packet)new PlayerMoveC2SPacket.Full(player.getX(), player.getY(), player.getZ(), player.getYaw(), player.getPitch(), player.isOnGround()));
                this.method_41931((ClientWorld)player.getWorld(), id -> new PlayerInteractItemC2SPacket(hand, id));
            }
            info.setReturnValue((Object)result.getResult());
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V", ordinal=0)}, method={"attackEntity"}, cancellable=true)
    public void attackEntity(PlayerEntity player, Entity entity, CallbackInfo info) {
        ActionResult result = ((AttackEntityCallback)AttackEntityCallback.EVENT.invoker()).interact(player, player.getEntityWorld(), Hand.MAIN_HAND, entity, null);
        if (result != ActionResult.PASS) {
            if (result == ActionResult.SUCCESS) {
                this.field_3720.sendPacket((Packet)PlayerInteractEntityC2SPacket.attack((Entity)entity, (boolean)player.isSneaking()));
            }
            info.cancel();
        }
    }

    @Shadow
    public abstract void method_41931(ClientWorld var1, SequencedPacketCreator var2);
}

